/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.domain.MetaData;
import org.axonframework.serializer.AnnotationRevisionResolver;
import org.axonframework.serializer.ChainingConverterFactory;
import org.axonframework.serializer.ConverterFactory;
import org.axonframework.serializer.RevisionResolver;
import org.axonframework.serializer.SerializationException;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.SerializedType;
import org.axonframework.serializer.Serializer;
import org.axonframework.serializer.SimpleSerializedObject;
import org.axonframework.serializer.SimpleSerializedType;
import org.axonframework.serializer.UnknownSerializedTypeException;
import org.axonframework.serializer.json.ByteArrayToJsonNodeConverter;
import org.axonframework.serializer.json.JodaDeserializer;
import org.axonframework.serializer.json.JsonNodeToByteArrayConverter;
import org.axonframework.serializer.json.MetaDataDeserializer;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.MonthDay;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.YearMonth;

public class JacksonSerializer
implements Serializer {
    private final RevisionResolver revisionResolver;
    private final ConverterFactory converterFactory;
    private final ObjectMapper objectMapper;
    private final ClassLoader classLoader;
    private final ConcurrentHashMap<String, Class> classCache = new ConcurrentHashMap();

    public JacksonSerializer() {
        this(new AnnotationRevisionResolver(), new ChainingConverterFactory());
    }

    public JacksonSerializer(ObjectMapper objectMapper) {
        this(objectMapper, new AnnotationRevisionResolver(), new ChainingConverterFactory());
    }

    public JacksonSerializer(RevisionResolver revisionResolver, ConverterFactory converterFactory) {
        this(new ObjectMapper(), revisionResolver, converterFactory);
    }

    public JacksonSerializer(ObjectMapper objectMapper, RevisionResolver revisionResolver) {
        this(objectMapper, revisionResolver, new ChainingConverterFactory());
    }

    public JacksonSerializer(ObjectMapper objectMapper, RevisionResolver revisionResolver, ConverterFactory converterFactory) {
        this(objectMapper, revisionResolver, converterFactory, null);
    }

    public JacksonSerializer(ObjectMapper objectMapper, RevisionResolver revisionResolver, ConverterFactory converterFactory, ClassLoader classLoader) {
        this.revisionResolver = revisionResolver;
        this.converterFactory = converterFactory;
        this.objectMapper = objectMapper;
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        this.objectMapper.registerModule((Module)new SimpleModule("Axon-Jackson Module").addSerializer(ReadableInstant.class, (JsonSerializer)new ToStringSerializer()).addDeserializer(MetaData.class, (JsonDeserializer)new MetaDataDeserializer()).addDeserializer(DateTime.class, new JodaDeserializer<DateTime>(DateTime.class)).addDeserializer(Instant.class, new JodaDeserializer<Instant>(Instant.class)).addDeserializer(MutableDateTime.class, new JodaDeserializer<MutableDateTime>(MutableDateTime.class)).addDeserializer(YearMonth.class, new JodaDeserializer<YearMonth>(YearMonth.class)).addDeserializer(MonthDay.class, new JodaDeserializer<MonthDay>(MonthDay.class)).addDeserializer(LocalDate.class, new JodaDeserializer<LocalDate>(LocalDate.class)).addDeserializer(LocalTime.class, new JodaDeserializer<LocalTime>(LocalTime.class)).addDeserializer(LocalDateTime.class, new JodaDeserializer<LocalDateTime>(LocalDateTime.class)));
        if (converterFactory instanceof ChainingConverterFactory) {
            this.registerConverters((ChainingConverterFactory)converterFactory);
        }
    }

    protected void registerConverters(ChainingConverterFactory converterFactory) {
        converterFactory.registerConverter(new JsonNodeToByteArrayConverter(this.objectMapper));
        converterFactory.registerConverter(new ByteArrayToJsonNodeConverter(this.objectMapper));
    }

    @Override
    public <T> SerializedObject<T> serialize(Object object, Class<T> expectedRepresentation) {
        try {
            if (String.class.equals(expectedRepresentation)) {
                return new SimpleSerializedObject<String>(this.getWriter().writeValueAsString(object), expectedRepresentation, this.typeForClass(object.getClass()));
            }
            byte[] serializedBytes = this.getWriter().writeValueAsBytes(object);
            T serializedContent = this.converterFactory.getConverter(byte[].class, expectedRepresentation).convert(serializedBytes);
            return new SimpleSerializedObject<T>(serializedContent, expectedRepresentation, this.typeForClass(object.getClass()));
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Unable to serialize object", e);
        }
    }

    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected ObjectWriter getWriter() {
        return this.objectMapper.writer();
    }

    protected ObjectReader getReader(Class<?> type) {
        return this.objectMapper.reader(type);
    }

    @Override
    public <T> boolean canSerializeTo(Class<T> expectedRepresentation) {
        return JsonNode.class.equals(expectedRepresentation) || String.class.equals(expectedRepresentation) || this.converterFactory.hasConverter(byte[].class, expectedRepresentation);
    }

    @Override
    public <S, T> T deserialize(SerializedObject<S> serializedObject) {
        try {
            if (JsonNode.class.equals(serializedObject.getContentType())) {
                return (T)this.getReader(this.classForType(serializedObject.getType())).readValue((JsonNode)serializedObject.getData());
            }
            byte[] byteSerialized = this.converterFactory.getConverter(serializedObject.getContentType(), byte[].class).convert(serializedObject);
            return (T)this.getReader(this.classForType(serializedObject.getType())).readValue((byte[])byteSerialized.getData());
        }
        catch (IOException e) {
            throw new SerializationException("Error while deserializing object", e);
        }
    }

    @Override
    public Class classForType(SerializedType type) throws UnknownSerializedTypeException {
        String cn = this.resolveClassName(type);
        Class result = this.classCache.get(cn);
        if (result == null) {
            result = this.loadClassForType(type);
            this.classCache.putIfAbsent(cn, result);
        }
        return result;
    }

    private Class loadClassForType(SerializedType type) throws UnknownSerializedTypeException {
        try {
            return this.classLoader.loadClass(this.resolveClassName(type));
        }
        catch (ClassNotFoundException e) {
            throw new UnknownSerializedTypeException(type, (Throwable)e);
        }
    }

    protected String resolveClassName(SerializedType serializedType) {
        return serializedType.getName();
    }

    @Override
    public SerializedType typeForClass(Class type) {
        return new SimpleSerializedType(type.getName(), this.revisionResolver.revisionOf(type));
    }

    @Override
    public ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }
}

