/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer;

import org.axonframework.common.Assert;
import org.axonframework.serializer.SerializedType;

public class SimpleSerializedType
implements SerializedType {
    private final String type;
    private final String revisionId;

    public SimpleSerializedType(String objectType, String revisionNumber) {
        Assert.notNull(objectType, "objectType cannot be null");
        this.type = objectType;
        this.revisionId = revisionNumber;
    }

    @Override
    public String getName() {
        return this.type;
    }

    @Override
    public String getRevision() {
        return this.revisionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSerializedType that = (SimpleSerializedType)o;
        if (this.revisionId != null ? !this.revisionId.equals(that.revisionId) : that.revisionId != null) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.revisionId != null ? this.revisionId.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("SimpleSerializedType[%s] (revision %s)", this.type, this.revisionId);
    }
}

