/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer;

import org.axonframework.common.Assert;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.SerializedType;
import org.axonframework.serializer.SimpleSerializedType;

public class SimpleSerializedObject<T>
implements SerializedObject<T> {
    private final T data;
    private final SerializedType type;
    private final Class<T> dataType;

    public SimpleSerializedObject(T data, Class<T> dataType, SerializedType serializedType) {
        Assert.notNull(data, "Data for a serialized object cannot be null");
        Assert.notNull(serializedType, "The type identifier of the serialized object");
        this.data = data;
        this.dataType = dataType;
        this.type = serializedType;
    }

    public SimpleSerializedObject(T data, Class<T> dataType, String type, String revision) {
        this(data, dataType, new SimpleSerializedType(type, revision));
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public Class<T> getContentType() {
        return this.dataType;
    }

    @Override
    public SerializedType getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSerializedObject that = (SimpleSerializedObject)o;
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        if (this.dataType != null ? !this.dataType.equals(that.dataType) : that.dataType != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    public int hashCode() {
        int result = this.data != null ? this.data.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("SimpleSerializedObject [%s]", this.type);
    }
}

