/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer;

import java.util.Map;
import org.axonframework.domain.EventMessage;
import org.axonframework.domain.GenericEventMessage;
import org.axonframework.domain.MetaData;
import org.axonframework.serializer.SerializationAware;
import org.axonframework.serializer.SerializedMessage;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.Serializer;
import org.joda.time.DateTime;

public class SerializedEventMessage<T>
implements EventMessage<T>,
SerializationAware {
    private static final long serialVersionUID = -4704515337335869770L;
    private final DateTime timestamp;
    private final SerializedMessage<T> message;

    public SerializedEventMessage(String eventIdentifier, DateTime timestamp, SerializedObject<?> serializedPayload, SerializedObject<?> serializedMetaData, Serializer serializer) {
        this.message = new SerializedMessage(eventIdentifier, serializedPayload, serializedMetaData, serializer);
        this.timestamp = timestamp;
    }

    private SerializedEventMessage(SerializedEventMessage<T> original, Map<String, ?> metaData) {
        this.message = original.message.withMetaData((Map)metaData);
        this.timestamp = original.getTimestamp();
    }

    public <R> SerializedObject<R> serializePayload(Serializer serializer, Class<R> expectedRepresentation) {
        return this.message.serializePayload(serializer, expectedRepresentation);
    }

    public <R> SerializedObject<R> serializeMetaData(Serializer serializer, Class<R> expectedRepresentation) {
        return this.message.serializeMetaData(serializer, expectedRepresentation);
    }

    @Override
    public String getIdentifier() {
        return this.message.getIdentifier();
    }

    @Override
    public DateTime getTimestamp() {
        return this.timestamp;
    }

    @Override
    public MetaData getMetaData() {
        return this.message.getMetaData();
    }

    @Override
    public T getPayload() {
        return this.message.getPayload();
    }

    @Override
    public Class getPayloadType() {
        return this.message.getPayloadType();
    }

    @Override
    public SerializedEventMessage<T> withMetaData(Map<String, ?> newMetaData) {
        if (this.getMetaData().equals(newMetaData)) {
            return this;
        }
        return new SerializedEventMessage<T>(this, newMetaData);
    }

    @Override
    public EventMessage<T> andMetaData(Map<String, ?> additionalMetaData) {
        MetaData newMetaData = this.getMetaData().mergedWith(additionalMetaData);
        return this.withMetaData((Map)newMetaData);
    }

    public boolean isPayloadDeserialized() {
        return this.message.isPayloadDeserialized();
    }

    protected Object writeReplace() {
        return new GenericEventMessage<T>(this.getIdentifier(), this.getTimestamp(), this.getPayload(), this.getMetaData());
    }
}

