/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer;

import org.axonframework.common.Assert;
import org.axonframework.domain.Message;
import org.axonframework.serializer.ConverterFactory;
import org.axonframework.serializer.SerializationAware;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.SerializedType;
import org.axonframework.serializer.Serializer;

public class MessageSerializer
implements Serializer {
    private final Serializer serializer;

    public MessageSerializer(Serializer serializer) {
        Assert.notNull(serializer, "serializer may not be null");
        this.serializer = serializer;
    }

    public static <T> SerializedObject<T> serializePayload(Message<?> message, Serializer serializer, Class<T> expectedRepresentation) {
        if (message instanceof SerializationAware) {
            return ((SerializationAware)((Object)message)).serializePayload(serializer, expectedRepresentation);
        }
        return serializer.serialize(message.getPayload(), expectedRepresentation);
    }

    public static <T> SerializedObject<T> serializeMetaData(Message<?> message, Serializer serializer, Class<T> expectedRepresentation) {
        if (message instanceof SerializationAware) {
            return ((SerializationAware)((Object)message)).serializeMetaData(serializer, expectedRepresentation);
        }
        return serializer.serialize(message.getMetaData(), expectedRepresentation);
    }

    public <T> SerializedObject<T> serializePayload(Message<?> message, Class<T> expectedRepresentation) {
        return MessageSerializer.serializePayload(message, this.serializer, expectedRepresentation);
    }

    public <T> SerializedObject<T> serializeMetaData(Message<?> message, Class<T> expectedRepresentation) {
        return MessageSerializer.serializeMetaData(message, this.serializer, expectedRepresentation);
    }

    @Override
    public <T> SerializedObject<T> serialize(Object object, Class<T> expectedRepresentation) {
        return this.serializer.serialize(object, expectedRepresentation);
    }

    @Override
    public <T> boolean canSerializeTo(Class<T> expectedRepresentation) {
        return this.serializer.canSerializeTo(expectedRepresentation);
    }

    @Override
    public <S, T> T deserialize(SerializedObject<S> serializedObject) {
        return this.serializer.deserialize(serializedObject);
    }

    @Override
    public Class classForType(SerializedType type) {
        return this.serializer.classForType(type);
    }

    @Override
    public SerializedType typeForClass(Class type) {
        return this.serializer.typeForClass(type);
    }

    @Override
    public ConverterFactory getConverterFactory() {
        return this.serializer.getConverterFactory();
    }
}

