/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.axonframework.common.Assert;
import org.axonframework.common.io.IOUtils;
import org.axonframework.serializer.ChainingConverterFactory;
import org.axonframework.serializer.ConverterFactory;
import org.axonframework.serializer.RevisionResolver;
import org.axonframework.serializer.SerialVersionUIDRevisionResolver;
import org.axonframework.serializer.SerializationException;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.SerializedType;
import org.axonframework.serializer.Serializer;
import org.axonframework.serializer.SimpleSerializedObject;
import org.axonframework.serializer.SimpleSerializedType;
import org.axonframework.serializer.UnknownSerializedTypeException;

public class JavaSerializer
implements Serializer {
    private final ConverterFactory converterFactory = new ChainingConverterFactory();
    private final RevisionResolver revisionResolver;

    public JavaSerializer() {
        this(new SerialVersionUIDRevisionResolver());
    }

    public JavaSerializer(RevisionResolver revisionResolver) {
        Assert.notNull(revisionResolver, "revisionResolver may not be null");
        this.revisionResolver = revisionResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SerializedObject<T> serialize(Object instance, Class<T> expectedType) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(instance);
            }
            finally {
                oos.flush();
            }
        }
        catch (IOException e) {
            throw new SerializationException("An exception occurred writing serialized data to the output stream", e);
        }
        T converted = this.converterFactory.getConverter(byte[].class, expectedType).convert(baos.toByteArray());
        return new SimpleSerializedObject<T>(converted, expectedType, instance.getClass().getName(), this.revisionOf(instance.getClass()));
    }

    @Override
    public <T> boolean canSerializeTo(Class<T> expectedRepresentation) {
        return this.converterFactory.hasConverter(byte[].class, expectedRepresentation);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <S, T> T deserialize(SerializedObject<S> serializedObject) {
        Object object;
        InputStream converted = this.converterFactory.getConverter(serializedObject.getContentType(), InputStream.class).convert(serializedObject);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream((InputStream)converted.getData());
            object = ois.readObject();
        }
        catch (ClassNotFoundException e) {
            try {
                throw new SerializationException("An error occurred while deserializing: " + e.getMessage(), e);
                catch (IOException e2) {
                    throw new SerializationException("An error occurred while deserializing: " + e2.getMessage(), e2);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(ois);
        return (T)object;
    }

    @Override
    public Class classForType(SerializedType type) {
        try {
            return Class.forName(type.getName());
        }
        catch (ClassNotFoundException e) {
            throw new UnknownSerializedTypeException(type, (Throwable)e);
        }
    }

    @Override
    public SerializedType typeForClass(Class type) {
        return new SimpleSerializedType(type.getName(), this.revisionOf(type));
    }

    @Override
    public ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    private String revisionOf(Class<?> type) {
        return this.revisionResolver.revisionOf(type);
    }
}

