/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serializer;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.MapConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.Mapper;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.UUID;
import org.axonframework.commandhandling.GenericCommandMessage;
import org.axonframework.common.Assert;
import org.axonframework.domain.GenericDomainEventMessage;
import org.axonframework.domain.GenericEventMessage;
import org.axonframework.domain.MetaData;
import org.axonframework.saga.AssociationValue;
import org.axonframework.saga.AssociationValues;
import org.axonframework.saga.annotation.AbstractAnnotatedSaga;
import org.axonframework.saga.annotation.AssociationValuesImpl;
import org.axonframework.serializer.AnnotationRevisionResolver;
import org.axonframework.serializer.ChainingConverterFactory;
import org.axonframework.serializer.ConverterFactory;
import org.axonframework.serializer.RevisionResolver;
import org.axonframework.serializer.SerializationException;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.SerializedType;
import org.axonframework.serializer.Serializer;
import org.axonframework.serializer.SimpleSerializedObject;
import org.axonframework.serializer.SimpleSerializedType;
import org.axonframework.serializer.UnknownSerializedTypeException;
import org.joda.time.DateTime;

public abstract class AbstractXStreamSerializer
implements Serializer {
    private static final Charset DEFAULT_CHARSET_NAME = Charset.forName("UTF-8");
    private final XStream xStream;
    private final Charset charset;
    private final RevisionResolver revisionResolver;
    private final ConverterFactory converterFactory;

    protected AbstractXStreamSerializer(XStream xStream) {
        this(xStream, new AnnotationRevisionResolver());
    }

    protected AbstractXStreamSerializer(XStream xStream, RevisionResolver revisionResolver) {
        this(DEFAULT_CHARSET_NAME, xStream, revisionResolver);
    }

    protected AbstractXStreamSerializer(Charset charset, XStream xStream) {
        this(charset, xStream, new AnnotationRevisionResolver(), new ChainingConverterFactory());
    }

    protected AbstractXStreamSerializer(Charset charset, XStream xStream, RevisionResolver revisionResolver) {
        this(charset, xStream, revisionResolver, new ChainingConverterFactory());
    }

    protected AbstractXStreamSerializer(Charset charset, XStream xStream, RevisionResolver revisionResolver, ConverterFactory converterFactory) {
        Assert.notNull(charset, "charset may not be null");
        Assert.notNull(xStream, "xStream may not be null");
        Assert.notNull(converterFactory, "converterFactory may not be null");
        Assert.notNull(revisionResolver, "revisionResolver may not be null");
        this.charset = charset;
        this.xStream = xStream;
        this.converterFactory = converterFactory;
        this.revisionResolver = revisionResolver;
        if (converterFactory instanceof ChainingConverterFactory) {
            this.registerConverters((ChainingConverterFactory)converterFactory);
        }
        xStream.registerConverter((Converter)new JodaTimeConverter());
        xStream.addImmutableType(UUID.class);
        xStream.aliasPackage("axon.domain", "org.axonframework.domain");
        xStream.aliasPackage("axon.es", "org.axonframework.eventsourcing");
        xStream.alias("domain-event", GenericDomainEventMessage.class);
        xStream.alias("event", GenericEventMessage.class);
        xStream.alias("command", GenericCommandMessage.class);
        xStream.addDefaultImplementation(AssociationValuesImpl.class, AssociationValues.class);
        xStream.aliasField("associations", AbstractAnnotatedSaga.class, "associationValues");
        xStream.alias("association", AssociationValue.class);
        xStream.aliasField("key", AssociationValue.class, "propertyKey");
        xStream.aliasField("value", AssociationValue.class, "propertyValue");
        xStream.alias("localDateTime", DateTime.class);
        xStream.alias("dateTime", DateTime.class);
        xStream.alias("uuid", UUID.class);
        xStream.alias("meta-data", MetaData.class);
        xStream.registerConverter((Converter)new MetaDataConverter(xStream.getMapper()));
    }

    protected abstract void registerConverters(ChainingConverterFactory var1);

    @Override
    public <T> boolean canSerializeTo(Class<T> expectedRepresentation) {
        return this.converterFactory.hasConverter(byte[].class, expectedRepresentation);
    }

    @Override
    public <T> SerializedObject<T> serialize(Object object, Class<T> expectedType) {
        T result = this.doSerialize(object, expectedType, this.xStream);
        return new SimpleSerializedObject<T>(result, expectedType, this.typeForClass(object.getClass()));
    }

    protected abstract <T> T doSerialize(Object var1, Class<T> var2, XStream var3);

    protected abstract Object doDeserialize(SerializedObject var1, XStream var2);

    protected <S, T> T convert(Class<S> sourceType, Class<T> targetType, S source) {
        return this.getConverterFactory().getConverter(sourceType, targetType).convert(source);
    }

    private String revisionOf(Class<?> type) {
        return this.revisionResolver.revisionOf(type);
    }

    @Override
    public <S, T> T deserialize(SerializedObject<S> serializedObject) {
        return (T)this.doDeserialize(serializedObject, this.xStream);
    }

    @Override
    public Class classForType(SerializedType type) {
        try {
            return this.xStream.getMapper().realClass(type.getName());
        }
        catch (CannotResolveClassException e) {
            throw new UnknownSerializedTypeException(type, (Throwable)e);
        }
    }

    @Override
    public SerializedType typeForClass(Class type) {
        return new SimpleSerializedType(this.typeIdentifierOf(type), this.revisionOf(type));
    }

    public void addAlias(String name, Class type) {
        this.xStream.alias(name, type);
    }

    public void addPackageAlias(String alias, String pkgName) {
        this.xStream.aliasPackage(alias, pkgName);
    }

    public void addFieldAlias(String alias, Class definedIn, String fieldName) {
        this.xStream.aliasField(alias, definedIn, fieldName);
    }

    public XStream getXStream() {
        return this.xStream;
    }

    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    private String typeIdentifierOf(Class<?> type) {
        return this.xStream.getMapper().serializedClass(type);
    }

    private static final class MetaDataConverter
    extends MapConverter {
        public MetaDataConverter(Mapper mapper) {
            super(mapper);
        }

        public boolean canConvert(Class type) {
            return MetaData.class.equals((Object)type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            MetaData metaData = (MetaData)source;
            if (!metaData.isEmpty()) {
                super.marshal(new HashMap<String, Object>(metaData), writer, context);
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            if (!reader.hasMoreChildren()) {
                return MetaData.emptyInstance();
            }
            HashMap contents = new HashMap();
            this.populateMap(reader, context, contents);
            if (contents.isEmpty()) {
                return MetaData.emptyInstance();
            }
            return MetaData.from(contents);
        }
    }

    private static final class JodaTimeConverter
    implements Converter {
        private JodaTimeConverter() {
        }

        public boolean canConvert(Class type) {
            return type != null && DateTime.class.getPackage().equals(type.getPackage());
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            writer.setValue(source.toString());
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            try {
                Constructor constructor = context.getRequiredType().getConstructor(Object.class);
                return constructor.newInstance(reader.getValue());
            }
            catch (Exception e) {
                throw new SerializationException(String.format("An exception occurred while deserializing a Joda Time object: %s", context.getRequiredType().getSimpleName()), e);
            }
        }
    }
}

