/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga.repository.jpa;

import javax.persistence.Basic;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.Transient;
import org.axonframework.saga.Saga;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.Serializer;
import org.axonframework.serializer.SimpleSerializedObject;

@Entity
public class SagaEntry {
    @Id
    private String sagaId;
    @Basic
    private String sagaType;
    @Basic
    private String revision;
    @Lob
    private byte[] serializedSaga;
    @Transient
    private transient Saga saga;

    public SagaEntry(Saga saga, Serializer serializer) {
        this.sagaId = saga.getSagaIdentifier();
        SerializedObject<byte[]> serialized = serializer.serialize(saga, byte[].class);
        this.serializedSaga = serialized.getData();
        this.sagaType = serialized.getType().getName();
        this.revision = serialized.getType().getRevision();
        this.saga = saga;
    }

    public Saga getSaga(Serializer serializer) {
        if (this.saga != null) {
            return this.saga;
        }
        return (Saga)serializer.deserialize(new SimpleSerializedObject<byte[]>(this.serializedSaga, byte[].class, this.sagaType, this.revision));
    }

    protected SagaEntry() {
    }

    public byte[] getSerializedSaga() {
        return this.serializedSaga;
    }

    public String getSagaId() {
        return this.sagaId;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getSagaType() {
        return this.sagaType;
    }
}

