/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga.repository.jpa;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityNotFoundException;
import org.axonframework.common.Assert;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.saga.AssociationValue;
import org.axonframework.saga.ResourceInjector;
import org.axonframework.saga.Saga;
import org.axonframework.saga.repository.AbstractSagaRepository;
import org.axonframework.saga.repository.jpa.AssociationValueEntry;
import org.axonframework.saga.repository.jpa.SagaEntry;
import org.axonframework.saga.repository.jpa.SerializedSaga;
import org.axonframework.serializer.JavaSerializer;
import org.axonframework.serializer.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JpaSagaRepository
extends AbstractSagaRepository {
    private static final Logger logger = LoggerFactory.getLogger(JpaSagaRepository.class);
    private static final String LOAD_SAGA_QUERY = "SELECT new org.axonframework.saga.repository.jpa.SerializedSaga(se.serializedSaga, se.sagaType, se.revision) FROM SagaEntry se WHERE se.sagaId = :sagaId";
    private static final String DELETE_ASSOCIATION_QUERY = "DELETE FROM AssociationValueEntry ae WHERE ae.associationKey = :associationKey AND ae.associationValue = :associationValue AND ae.sagaType = :sagaType AND ae.sagaId = :sagaId";
    private static final String FIND_ASSOCIATION_IDS_QUERY = "SELECT ae.sagaId FROM AssociationValueEntry ae WHERE ae.associationKey = :associationKey AND ae.associationValue = :associationValue AND ae.sagaType = :sagaType";
    private static final String DELETE_ASSOCIATIONS_QUERY = "DELETE FROM AssociationValueEntry ae WHERE ae.sagaId = :sagaId";
    private static final String DELETE_SAGA_QUERY = "DELETE FROM SagaEntry se WHERE se.sagaId = :id";
    private static final String UPDATE_SAGA_QUERY = "UPDATE SagaEntry s SET s.serializedSaga = :serializedSaga, s.revision = :revision WHERE s.sagaId = :sagaId AND s.sagaType = :sagaType";
    private static final String LOAD_SAGA_NAMED_QUERY = "LOAD_SAGA_NAMED_QUERY";
    private static final String DELETE_ASSOCIATION_NAMED_QUERY = "DELETE_ASSOCIATION_NAMED_QUERY";
    private static final String FIND_ASSOCIATION_IDS_NAMED_QUERY = "FIND_ASSOCIATION_IDS_NAMED_QUERY";
    private static final String DELETE_ASSOCIATIONS_NAMED_QUERY = "DELETE_ASSOCIATIONS_NAMED_QUERY";
    private static final String DELETE_SAGA_NAMED_QUERY = "DELETE_SAGA_NAMED_QUERY";
    private static final String UPDATE_SAGA_NAMED_QUERY = "UPDATE_SAGA_NAMED_QUERY";
    private final EntityManagerProvider entityManagerProvider;
    private ResourceInjector injector;
    private Serializer serializer;
    private volatile boolean useExplicitFlush = true;

    public JpaSagaRepository(EntityManagerProvider entityManagerProvider) {
        Assert.notNull(entityManagerProvider, "entityManagerProvider may not be null");
        this.entityManagerProvider = entityManagerProvider;
        this.serializer = new JavaSerializer();
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        EntityManagerFactory entityManagerFactory = entityManager.getEntityManagerFactory();
        entityManagerFactory.addNamedQuery(LOAD_SAGA_NAMED_QUERY, entityManager.createQuery(LOAD_SAGA_QUERY));
        entityManagerFactory.addNamedQuery(DELETE_ASSOCIATION_NAMED_QUERY, entityManager.createQuery(DELETE_ASSOCIATION_QUERY));
        entityManagerFactory.addNamedQuery(FIND_ASSOCIATION_IDS_NAMED_QUERY, entityManager.createQuery(FIND_ASSOCIATION_IDS_QUERY));
        entityManagerFactory.addNamedQuery(DELETE_ASSOCIATIONS_NAMED_QUERY, entityManager.createQuery(DELETE_ASSOCIATIONS_QUERY));
        entityManagerFactory.addNamedQuery(DELETE_SAGA_NAMED_QUERY, entityManager.createQuery(DELETE_SAGA_QUERY));
        entityManagerFactory.addNamedQuery(UPDATE_SAGA_NAMED_QUERY, entityManager.createQuery(UPDATE_SAGA_QUERY));
    }

    @Override
    public Saga load(String sagaId) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        List serializedSagaList = entityManager.createNamedQuery(LOAD_SAGA_NAMED_QUERY).setParameter("sagaId", (Object)sagaId).setMaxResults(1).getResultList();
        if (serializedSagaList == null || serializedSagaList.isEmpty()) {
            return null;
        }
        SerializedSaga serializedSaga = (SerializedSaga)serializedSagaList.get(0);
        Saga loadedSaga = (Saga)this.serializer.deserialize(serializedSaga);
        if (this.injector != null) {
            this.injector.injectResources(loadedSaga);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Loaded saga id [{}] of type [{}]", (Object)sagaId, (Object)loadedSaga.getClass().getName());
        }
        return loadedSaga;
    }

    @Override
    protected void removeAssociationValue(AssociationValue associationValue, String sagaType, String sagaIdentifier) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        int updateCount = entityManager.createNamedQuery(DELETE_ASSOCIATION_NAMED_QUERY).setParameter("associationKey", (Object)associationValue.getKey()).setParameter("associationValue", (Object)associationValue.getValue()).setParameter("sagaType", (Object)sagaType).setParameter("sagaId", (Object)sagaIdentifier).executeUpdate();
        if (updateCount == 0 && logger.isWarnEnabled()) {
            logger.warn("Wanted to remove association value, but it was already gone: sagaId= {}, key={}, value={}", new Object[]{sagaIdentifier, associationValue.getKey(), associationValue.getValue()});
        }
    }

    @Override
    protected String typeOf(Class<? extends Saga> sagaClass) {
        return this.serializer.typeForClass(sagaClass).getName();
    }

    @Override
    protected void storeAssociationValue(AssociationValue associationValue, String sagaType, String sagaIdentifier) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        entityManager.persist((Object)new AssociationValueEntry(sagaType, sagaIdentifier, associationValue));
        if (this.useExplicitFlush) {
            entityManager.flush();
        }
    }

    @Override
    protected Set<String> findAssociatedSagaIdentifiers(Class<? extends Saga> type, AssociationValue associationValue) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        List entries = entityManager.createNamedQuery(FIND_ASSOCIATION_IDS_NAMED_QUERY).setParameter("associationKey", (Object)associationValue.getKey()).setParameter("associationValue", (Object)associationValue.getValue()).setParameter("sagaType", (Object)this.typeOf(type)).getResultList();
        return new TreeSet<String>(entries);
    }

    @Override
    protected void deleteSaga(Saga saga) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        try {
            entityManager.createNamedQuery(DELETE_ASSOCIATIONS_NAMED_QUERY).setParameter("sagaId", (Object)saga.getSagaIdentifier()).executeUpdate();
            entityManager.createNamedQuery(DELETE_SAGA_NAMED_QUERY).setParameter("id", (Object)saga.getSagaIdentifier()).executeUpdate();
        }
        catch (EntityNotFoundException e) {
            logger.info("Could not delete SagaEntry {}, it appears to have already been deleted.", (Object)saga.getSagaIdentifier());
        }
        entityManager.flush();
    }

    @Override
    protected void updateSaga(Saga saga) {
        int updateCount;
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        SagaEntry entry = new SagaEntry(saga, this.serializer);
        if (logger.isDebugEnabled()) {
            logger.debug("Updating saga id {} as {}", (Object)saga.getSagaIdentifier(), (Object)new String(entry.getSerializedSaga(), Charset.forName("UTF-8")));
        }
        if (this.useExplicitFlush) {
            entityManager.flush();
        }
        if ((updateCount = entityManager.createNamedQuery(UPDATE_SAGA_NAMED_QUERY).setParameter("serializedSaga", (Object)entry.getSerializedSaga()).setParameter("revision", (Object)entry.getRevision()).setParameter("sagaId", (Object)entry.getSagaId()).setParameter("sagaType", (Object)entry.getSagaType()).executeUpdate()) == 0) {
            logger.warn("Expected to be able to update a Saga instance, but no rows were found. Inserting instead.");
            entityManager.persist((Object)entry);
            if (this.useExplicitFlush) {
                entityManager.flush();
            }
        }
    }

    @Override
    protected void storeSaga(Saga saga) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        SagaEntry entry = new SagaEntry(saga, this.serializer);
        entityManager.persist((Object)entry);
        if (logger.isDebugEnabled()) {
            logger.debug("Storing saga id {} as {}", (Object)saga.getSagaIdentifier(), (Object)new String(entry.getSerializedSaga(), Charset.forName("UTF-8")));
        }
        if (this.useExplicitFlush) {
            entityManager.flush();
        }
    }

    public void setResourceInjector(ResourceInjector resourceInjector) {
        this.injector = resourceInjector;
    }

    public void setSerializer(Serializer serializer) {
        this.serializer = serializer;
    }

    public void setUseExplicitFlush(boolean useExplicitFlush) {
        this.useExplicitFlush = useExplicitFlush;
    }
}

