/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga.repository;

import java.util.HashSet;
import java.util.Set;
import org.axonframework.cache.Cache;
import org.axonframework.common.Assert;
import org.axonframework.common.lock.IdentifierBasedLock;
import org.axonframework.saga.AssociationValue;
import org.axonframework.saga.Saga;
import org.axonframework.saga.SagaRepository;

public class CachingSagaRepository
implements SagaRepository {
    private final SagaRepository delegate;
    private final IdentifierBasedLock associationsCacheLock = new IdentifierBasedLock();
    private final Cache associationsCache;
    private final Cache sagaCache;

    public CachingSagaRepository(SagaRepository delegate, Cache associationsCache, Cache sagaCache) {
        Assert.notNull(delegate, "You must provide a SagaRepository instance to delegate to");
        Assert.notNull(associationsCache, "You must provide a Cache instance to store the association values");
        Assert.notNull(sagaCache, "You must provide a Cache instance to store the sagas");
        this.delegate = delegate;
        this.associationsCache = associationsCache;
        this.sagaCache = sagaCache;
    }

    @Override
    public Set<String> find(Class<? extends Saga> type, AssociationValue associationValue) {
        String key = this.cacheKey(associationValue, type.getName());
        Set<String> associations = (Set<String>)this.associationsCache.get(key);
        if (associations == null) {
            associations = this.feedCache(type, associationValue, key);
        }
        return new HashSet<String>(associations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> feedCache(Class<? extends Saga> type, AssociationValue associationValue, String key) {
        this.associationsCacheLock.obtainLock(key);
        try {
            Set<String> associations = (Set<String>)this.associationsCache.get(key);
            if (associations == null) {
                associations = this.delegate.find(type, associationValue);
                this.associationsCache.put(key, associations);
            }
            Set<String> set = associations;
            return set;
        }
        finally {
            this.associationsCacheLock.releaseLock(key);
        }
    }

    @Override
    public Saga load(String sagaIdentifier) {
        Saga saga = (Saga)this.sagaCache.get(sagaIdentifier);
        if (saga == null) {
            saga = this.delegate.load(sagaIdentifier);
            this.sagaCache.put(sagaIdentifier, saga);
        }
        return saga;
    }

    @Override
    public void commit(Saga saga) {
        String sagaIdentifier = saga.getSagaIdentifier();
        this.sagaCache.put(sagaIdentifier, saga);
        if (saga.isActive()) {
            this.updateAssociations(saga, sagaIdentifier);
        } else {
            this.removeCachedAssociations(saga.getAssociationValues(), sagaIdentifier, saga.getClass().getName());
        }
        this.delegate.commit(saga);
    }

    @Override
    public void add(Saga saga) {
        String sagaIdentifier = saga.getSagaIdentifier();
        this.sagaCache.put(sagaIdentifier, saga);
        this.updateAssociations(saga, sagaIdentifier);
        this.delegate.add(saga);
    }

    private void updateAssociations(Saga saga, String sagaIdentifier) {
        String sagaType = saga.getClass().getName();
        this.addCachedAssociations(saga.getAssociationValues().addedAssociations(), sagaIdentifier, sagaType);
        this.removeCachedAssociations(saga.getAssociationValues().removedAssociations(), sagaIdentifier, sagaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCachedAssociations(Iterable<AssociationValue> associationValues, String sagaIdentifier, String sagaType) {
        for (AssociationValue associationValue : associationValues) {
            String key = this.cacheKey(associationValue, sagaType);
            this.associationsCacheLock.obtainLock(key);
            try {
                Set identifiers = (Set)this.associationsCache.get(key);
                if (identifiers == null || !identifiers.add(sagaIdentifier)) continue;
                this.associationsCache.put(key, identifiers);
            }
            finally {
                this.associationsCacheLock.releaseLock(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCachedAssociations(Iterable<AssociationValue> associationValues, String sagaIdentifier, String sagaType) {
        for (AssociationValue associationValue : associationValues) {
            String key = this.cacheKey(associationValue, sagaType);
            this.associationsCacheLock.obtainLock(key);
            try {
                Set identifiers = (Set)this.associationsCache.get(key);
                if (identifiers == null || !identifiers.remove(sagaIdentifier)) continue;
                this.associationsCache.put(key, identifiers);
            }
            finally {
                this.associationsCacheLock.releaseLock(key);
            }
        }
    }

    private String cacheKey(AssociationValue associationValue, String sagaType) {
        return sagaType + "/" + associationValue.getKey() + "=" + associationValue.getValue();
    }
}

