/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga.annotation;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.axonframework.common.annotation.AbstractAnnotatedHandlerDefinition;
import org.axonframework.common.annotation.MethodMessageHandler;
import org.axonframework.common.annotation.MethodMessageHandlerInspector;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.domain.EventMessage;
import org.axonframework.saga.AssociationValue;
import org.axonframework.saga.annotation.AbstractAnnotatedSaga;
import org.axonframework.saga.annotation.SagaEventHandler;
import org.axonframework.saga.annotation.SagaMethodMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaMethodMessageHandlerInspector<T extends AbstractAnnotatedSaga> {
    private static final Logger logger = LoggerFactory.getLogger(SagaMethodMessageHandlerInspector.class);
    private static final ConcurrentMap<Class<?>, SagaMethodMessageHandlerInspector> INSPECTORS = new ConcurrentHashMap();
    private final Set<SagaMethodMessageHandler> handlers = new TreeSet<SagaMethodMessageHandler>();
    private final Class<T> sagaType;
    private final ParameterResolverFactory parameterResolverFactory;

    public static <T extends AbstractAnnotatedSaga> SagaMethodMessageHandlerInspector<T> getInstance(Class<T> sagaType, ParameterResolverFactory parameterResolverFactory) {
        SagaMethodMessageHandlerInspector<T> sagaInspector = (SagaMethodMessageHandlerInspector<T>)INSPECTORS.get(sagaType);
        if (sagaInspector == null || sagaInspector.getParameterResolverFactory() != parameterResolverFactory) {
            sagaInspector = new SagaMethodMessageHandlerInspector<T>(sagaType, parameterResolverFactory);
            INSPECTORS.put(sagaType, sagaInspector);
        }
        return sagaInspector;
    }

    protected SagaMethodMessageHandlerInspector(Class<T> sagaType, ParameterResolverFactory parameterResolverFactory) {
        this.parameterResolverFactory = parameterResolverFactory;
        MethodMessageHandlerInspector inspector = MethodMessageHandlerInspector.getInstance(sagaType, parameterResolverFactory, true, AnnotatedHandlerDefinition.INSTANCE);
        for (MethodMessageHandler handler : inspector.getHandlers()) {
            this.handlers.add(SagaMethodMessageHandler.getInstance(handler));
        }
        this.sagaType = sagaType;
    }

    public List<SagaMethodMessageHandler> getMessageHandlers(EventMessage event) {
        ArrayList<SagaMethodMessageHandler> found = new ArrayList<SagaMethodMessageHandler>(1);
        for (SagaMethodMessageHandler handler : this.handlers) {
            if (!handler.matches(event)) continue;
            found.add(handler);
        }
        return found;
    }

    public SagaMethodMessageHandler findHandlerMethod(AbstractAnnotatedSaga target, EventMessage event) {
        for (SagaMethodMessageHandler handler : this.getMessageHandlers(event)) {
            AssociationValue associationValue = handler.getAssociationValue(event);
            if (target.getAssociationValues().contains(associationValue)) {
                return handler;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Skipping handler [{}], it requires an association value [{}:{}] that this Saga is not associated with", new Object[]{handler.getName(), associationValue.getKey(), associationValue.getValue()});
        }
        if (logger.isDebugEnabled()) {
            logger.debug("No suitable handler was found for event of type", (Object)event.getPayloadType().getName());
        }
        return SagaMethodMessageHandler.noHandler();
    }

    public Class<T> getSagaType() {
        return this.sagaType;
    }

    public ParameterResolverFactory getParameterResolverFactory() {
        return this.parameterResolverFactory;
    }

    private static final class AnnotatedHandlerDefinition
    extends AbstractAnnotatedHandlerDefinition<SagaEventHandler> {
        private static final AnnotatedHandlerDefinition INSTANCE = new AnnotatedHandlerDefinition();

        private AnnotatedHandlerDefinition() {
            super(SagaEventHandler.class);
        }

        @Override
        protected Class<?> getDefinedPayload(SagaEventHandler annotation) {
            return annotation.payloadType();
        }
    }
}

