/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga.annotation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.annotation.MessageHandlerInvocationException;
import org.axonframework.common.annotation.MethodMessageHandler;
import org.axonframework.common.property.Property;
import org.axonframework.common.property.PropertyAccessStrategy;
import org.axonframework.domain.EventMessage;
import org.axonframework.saga.AssociationValue;
import org.axonframework.saga.SagaCreationPolicy;
import org.axonframework.saga.annotation.EndSaga;
import org.axonframework.saga.annotation.SagaEventHandler;
import org.axonframework.saga.annotation.StartSaga;

public class SagaMethodMessageHandler
implements Comparable<SagaMethodMessageHandler> {
    private static final SagaMethodMessageHandler NO_HANDLER_CONFIGURATION = new SagaMethodMessageHandler(SagaCreationPolicy.NONE, null, null, null, null);
    private final SagaCreationPolicy creationPolicy;
    private final MethodMessageHandler handlerMethod;
    private final String associationKey;
    private final String associationPropertyName;
    private final Property associationProperty;

    public static SagaMethodMessageHandler noHandler() {
        return NO_HANDLER_CONFIGURATION;
    }

    public static SagaMethodMessageHandler getInstance(MethodMessageHandler methodHandler) {
        Method handlerMethod = methodHandler.getMethod();
        SagaEventHandler handlerAnnotation = handlerMethod.getAnnotation(SagaEventHandler.class);
        String associationPropertyName = handlerAnnotation.associationProperty();
        Property associationProperty = PropertyAccessStrategy.getProperty(methodHandler.getPayloadType(), associationPropertyName);
        if (associationProperty == null) {
            throw new AxonConfigurationException(String.format("SagaEventHandler %s.%s defines a property %s that is not defined on the Event it declares to handle (%s)", methodHandler.getMethod().getDeclaringClass().getName(), methodHandler.getMethodName(), associationPropertyName, methodHandler.getPayloadType().getName()));
        }
        String associationKey = handlerAnnotation.keyName().isEmpty() ? associationPropertyName : handlerAnnotation.keyName();
        StartSaga startAnnotation = handlerMethod.getAnnotation(StartSaga.class);
        SagaCreationPolicy sagaCreationPolicy = startAnnotation == null ? SagaCreationPolicy.NONE : (startAnnotation.forceNew() ? SagaCreationPolicy.ALWAYS : SagaCreationPolicy.IF_NONE_FOUND);
        return new SagaMethodMessageHandler(sagaCreationPolicy, methodHandler, associationKey, associationPropertyName, associationProperty);
    }

    protected SagaMethodMessageHandler(SagaCreationPolicy creationPolicy, MethodMessageHandler handler, String associationKey, String associationPropertyName, Property associationProperty) {
        this.creationPolicy = creationPolicy;
        this.handlerMethod = handler;
        this.associationKey = associationKey;
        this.associationPropertyName = associationPropertyName;
        this.associationProperty = associationProperty;
    }

    public boolean isHandlerAvailable() {
        return this.handlerMethod != null;
    }

    public AssociationValue getAssociationValue(EventMessage eventMessage) {
        if (this.associationProperty == null) {
            return null;
        }
        Object associationValue = this.associationProperty.getValue(eventMessage.getPayload());
        return associationValue == null ? null : new AssociationValue(this.associationKey, associationValue.toString());
    }

    public SagaCreationPolicy getCreationPolicy() {
        return this.creationPolicy;
    }

    public boolean matches(EventMessage message) {
        return this.handlerMethod != null && this.handlerMethod.matches(message);
    }

    public boolean isEndingHandler() {
        return this.handlerMethod != null && this.handlerMethod.getMethod().isAnnotationPresent(EndSaga.class);
    }

    @Override
    public int compareTo(SagaMethodMessageHandler o) {
        if (this.handlerMethod == null && o.handlerMethod == null) {
            return 0;
        }
        if (this.handlerMethod == null) {
            return -1;
        }
        if (o.handlerMethod == null) {
            return 1;
        }
        int handlerEquality = this.handlerMethod.compareTo(o.handlerMethod);
        if (handlerEquality == 0) {
            handlerEquality = o.handlerMethod.getMethod().getParameterTypes().length - this.handlerMethod.getMethod().getParameterTypes().length;
        }
        if (handlerEquality == 0) {
            handlerEquality = this.associationKey.compareTo(o.associationKey);
        }
        if (handlerEquality == 0) {
            handlerEquality = this.associationPropertyName.compareTo(o.associationPropertyName);
        }
        return handlerEquality;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SagaMethodMessageHandler that = (SagaMethodMessageHandler)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return this.handlerMethod != null ? this.handlerMethod.hashCode() : 0;
    }

    public void invoke(Object target, EventMessage message) {
        if (!this.isHandlerAvailable()) {
            return;
        }
        try {
            this.handlerMethod.invoke(target, message);
        }
        catch (IllegalAccessException e) {
            throw new MessageHandlerInvocationException("Access to the message handler method was denied.", e);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new MessageHandlerInvocationException("An exception occurred while invoking the handler method.", e);
        }
    }

    public String getName() {
        return this.handlerMethod.getMethodName();
    }
}

