/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga.annotation;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.axonframework.common.AxonNonTransientException;
import org.axonframework.domain.EventMessage;
import org.axonframework.eventhandling.async.RetryPolicy;
import org.axonframework.saga.Saga;
import org.axonframework.saga.annotation.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryingErrorHandler
implements ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(RetryingErrorHandler.class);
    private final TimeoutConfiguration[] timeoutConfigurations;

    public RetryingErrorHandler() {
        this(new TimeoutConfiguration(2L, TimeUnit.SECONDS));
    }

    public RetryingErrorHandler(TimeoutConfiguration ... timeoutConfigurations) {
        this.timeoutConfigurations = Arrays.copyOf(timeoutConfigurations, timeoutConfigurations.length);
    }

    @Override
    public RetryPolicy onErrorPreparing(Class<? extends Saga> sagaType, EventMessage<?> publishedEvent, int invocationCount, Exception e) {
        return this.policyFor(invocationCount, sagaType, publishedEvent, e, "prepare");
    }

    @Override
    public RetryPolicy onErrorInvoking(Saga saga, EventMessage publishedEvent, int invocationCount, Exception e) {
        return this.policyFor(invocationCount, saga.getClass(), publishedEvent, e, "invoke");
    }

    protected boolean isTransient(Throwable exception) {
        return !AxonNonTransientException.isCauseOf(exception);
    }

    private RetryPolicy policyFor(int invocationCount, Class<?> sagaType, EventMessage publishedEvent, Throwable e, String task) {
        if (!this.isTransient(e)) {
            logger.error("An non-recoverable error occurred while trying to prepare sagas of type [{}] for invocation of event [{}]. Proceeding with the next event.", new Object[]{sagaType.getName(), publishedEvent.getPayloadType().getName(), e});
            return RetryPolicy.proceed();
        }
        int c = invocationCount;
        for (TimeoutConfiguration configuration : this.timeoutConfigurations) {
            if (c <= configuration.count() || configuration.count() < 0) {
                return configuration.retryPolicy();
            }
            c -= configuration.count();
        }
        logger.error("Giving up on retrying after {} attempts to " + task + " sagas of type [{}] for event [{}]. " + "Proceeding with the next event.", new Object[]{invocationCount, sagaType.getName(), publishedEvent.getPayloadType().getName(), e});
        return RetryPolicy.proceed();
    }

    public static class TimeoutConfiguration {
        private final int count;
        private final RetryPolicy retryPolicy;

        public TimeoutConfiguration(long timeout, TimeUnit timeUnit) {
            this.count = -1;
            this.retryPolicy = RetryPolicy.retryAfter(timeout, timeUnit);
        }

        public TimeoutConfiguration(int count, long timeout, TimeUnit timeUnit) {
            this.count = count;
            this.retryPolicy = RetryPolicy.retryAfter(timeout, timeUnit);
        }

        public int count() {
            return this.count;
        }

        public RetryPolicy retryPolicy() {
            return this.retryPolicy;
        }
    }
}

