/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga.annotation;

import com.lmax.disruptor.EventFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.axonframework.domain.EventMessage;
import org.axonframework.saga.AssociationValue;
import org.axonframework.saga.Saga;
import org.axonframework.saga.SagaCreationPolicy;
import org.axonframework.saga.annotation.AbstractAnnotatedSaga;
import org.axonframework.saga.annotation.AsyncSagaCreationElector;
import org.axonframework.saga.annotation.SagaMethodMessageHandler;

public class AsyncSagaProcessingEvent {
    private EventMessage publishedEvent;
    private final List<SagaMethodMessageHandler> handlers = new ArrayList<SagaMethodMessageHandler>();
    private Class<? extends AbstractAnnotatedSaga> sagaType;
    private AbstractAnnotatedSaga newSaga;
    private final AsyncSagaCreationElector elector = new AsyncSagaCreationElector();
    private SagaMethodMessageHandler creationHandler;
    private AssociationValue initialAssociationValue;
    private final Set<AssociationValue> associationValues = new HashSet<AssociationValue>();

    public EventMessage getPublishedEvent() {
        return this.publishedEvent;
    }

    public List<SagaMethodMessageHandler> getHandlers() {
        return this.handlers;
    }

    public Class<? extends Saga> getSagaType() {
        return this.sagaType;
    }

    public boolean waitForSagaCreationVote(boolean didEventInvocation, int processorCount, boolean ownsNewSagaInstance) {
        return this.elector.waitForSagaCreationVote(didEventInvocation, processorCount, ownsNewSagaInstance);
    }

    public AbstractAnnotatedSaga getNewSaga() {
        return this.newSaga;
    }

    public void reset(EventMessage nextEvent, Class<? extends AbstractAnnotatedSaga> nextSagaType, List<SagaMethodMessageHandler> nextHandlers, AbstractAnnotatedSaga nextSagaInstance) {
        this.elector.clear();
        this.publishedEvent = nextEvent;
        this.sagaType = nextSagaType;
        this.handlers.clear();
        this.handlers.addAll(nextHandlers);
        this.creationHandler = SagaMethodMessageHandler.noHandler();
        this.initialAssociationValue = null;
        this.associationValues.clear();
        for (SagaMethodMessageHandler handler : this.handlers) {
            if (!this.creationHandler.isHandlerAvailable() && handler.getCreationPolicy() != SagaCreationPolicy.NONE) {
                this.creationHandler = handler;
                this.initialAssociationValue = this.creationHandler.getAssociationValue(nextEvent);
            }
            this.associationValues.add(handler.getAssociationValue(nextEvent));
        }
        this.newSaga = nextSagaInstance;
    }

    public SagaMethodMessageHandler getCreationHandler() {
        return this.creationHandler;
    }

    public AssociationValue getInitialAssociationValue() {
        return this.initialAssociationValue;
    }

    public Set<AssociationValue> getAssociationValues() {
        return this.associationValues;
    }

    static class Factory
    implements EventFactory<AsyncSagaProcessingEvent> {
        Factory() {
        }

        public AsyncSagaProcessingEvent newInstance() {
            return new AsyncSagaProcessingEvent();
        }
    }
}

