/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga.annotation;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncSagaCreationElector {
    private static final Logger logger = LoggerFactory.getLogger(AsyncSagaCreationElector.class);
    private final ReentrantLock votingLock = new ReentrantLock();
    private final Condition allVotesCast = this.votingLock.newCondition();
    private int castVotes = 0;
    private volatile boolean invocationDetected = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForSagaCreationVote(boolean didInvocation, int totalVotesExpected, boolean isSagaOwner) {
        this.votingLock.lock();
        try {
            this.invocationDetected = this.invocationDetected || didInvocation;
            ++this.castVotes;
            while (isSagaOwner && !this.invocationDetected && this.castVotes < totalVotesExpected) {
                try {
                    this.allVotesCast.await();
                }
                catch (InterruptedException e) {
                    logger.warn("This thread has been interrupted, but the interruption has been ignored to prevent loss of information.");
                }
            }
            if (isSagaOwner) {
                boolean bl = !this.invocationDetected;
                return bl;
            }
            this.allVotesCast.signalAll();
        }
        finally {
            this.votingLock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.votingLock.lock();
        try {
            this.castVotes = 0;
            this.invocationDetected = false;
        }
        finally {
            this.votingLock.unlock();
        }
    }
}

