/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga.annotation;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.axonframework.saga.AssociationValue;
import org.axonframework.saga.AssociationValues;

public class AssociationValuesImpl
implements AssociationValues,
Serializable {
    private static final long serialVersionUID = 8273718165811296962L;
    private final Set<AssociationValue> values = new CopyOnWriteArraySet<AssociationValue>();
    private transient Set<AssociationValue> addedValues = new HashSet<AssociationValue>();
    private transient Set<AssociationValue> removedValues = new HashSet<AssociationValue>();

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean contains(AssociationValue associationValue) {
        return this.values.contains(associationValue);
    }

    @Override
    public Iterator<AssociationValue> iterator() {
        return Collections.unmodifiableSet(this.values).iterator();
    }

    @Override
    public boolean add(AssociationValue associationValue) {
        boolean added = this.values.add(associationValue);
        if (added) {
            this.initializeChangeTrackers();
            if (!this.removedValues.remove(associationValue)) {
                this.addedValues.add(associationValue);
            }
        }
        return added;
    }

    @Override
    public boolean remove(AssociationValue associationValue) {
        boolean removed = this.values.remove(associationValue);
        if (removed) {
            this.initializeChangeTrackers();
            if (!this.addedValues.remove(associationValue)) {
                this.removedValues.add(associationValue);
            }
        }
        return removed;
    }

    private void initializeChangeTrackers() {
        if (this.removedValues == null) {
            this.removedValues = new HashSet<AssociationValue>();
        }
        if (this.addedValues == null) {
            this.addedValues = new HashSet<AssociationValue>();
        }
    }

    @Override
    public Set<AssociationValue> asSet() {
        return Collections.unmodifiableSet(this.values);
    }

    @Override
    public Set<AssociationValue> removedAssociations() {
        if (this.removedValues == null || this.removedValues.isEmpty()) {
            return Collections.emptySet();
        }
        return this.removedValues;
    }

    @Override
    public Set<AssociationValue> addedAssociations() {
        if (this.addedValues == null || this.addedValues.isEmpty()) {
            return Collections.emptySet();
        }
        return this.addedValues;
    }

    @Override
    public void commit() {
        if (this.addedValues != null) {
            this.addedValues.clear();
        }
        if (this.removedValues != null) {
            this.removedValues.clear();
        }
    }
}

