/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.axonframework.domain.EventMessage;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.saga.AbstractSagaManager;
import org.axonframework.saga.AssociationValue;
import org.axonframework.saga.AssociationValueResolver;
import org.axonframework.saga.GenericSagaFactory;
import org.axonframework.saga.Saga;
import org.axonframework.saga.SagaCreationPolicy;
import org.axonframework.saga.SagaFactory;
import org.axonframework.saga.SagaInitializationPolicy;
import org.axonframework.saga.SagaRepository;

public class SimpleSagaManager
extends AbstractSagaManager {
    private final AssociationValueResolver associationValueResolver;
    private List<Class<?>> eventsToAlwaysCreateNewSagasFor = Collections.emptyList();
    private List<Class<?>> eventsToOptionallyCreateNewSagasFor = Collections.emptyList();
    private final Class<? extends Saga> sagaType;

    @Deprecated
    public SimpleSagaManager(Class<? extends Saga> sagaType, SagaRepository sagaRepository, AssociationValueResolver associationValueResolver, EventBus eventBus) {
        this(sagaType, sagaRepository, associationValueResolver, new GenericSagaFactory(), eventBus);
    }

    @Deprecated
    public SimpleSagaManager(Class<? extends Saga> sagaType, SagaRepository sagaRepository, AssociationValueResolver associationValueResolver, SagaFactory sagaFactory, EventBus eventBus) {
        super(eventBus, sagaRepository, sagaFactory, sagaType);
        this.sagaType = sagaType;
        this.associationValueResolver = associationValueResolver;
    }

    public SimpleSagaManager(Class<? extends Saga> sagaType, SagaRepository sagaRepository, AssociationValueResolver associationValueResolver) {
        this(sagaType, sagaRepository, associationValueResolver, new GenericSagaFactory());
    }

    public SimpleSagaManager(Class<? extends Saga> sagaType, SagaRepository sagaRepository, AssociationValueResolver associationValueResolver, SagaFactory sagaFactory) {
        super(sagaRepository, sagaFactory, sagaType);
        this.sagaType = sagaType;
        this.associationValueResolver = associationValueResolver;
    }

    @Override
    protected SagaInitializationPolicy getSagaCreationPolicy(Class<? extends Saga> type, EventMessage event) {
        AssociationValue initialAssociationValue = this.initialAssociationValue(event);
        if (this.isAssignableClassIn(event.getPayloadType(), this.eventsToOptionallyCreateNewSagasFor)) {
            return new SagaInitializationPolicy(SagaCreationPolicy.IF_NONE_FOUND, initialAssociationValue);
        }
        if (this.isAssignableClassIn(event.getPayloadType(), this.eventsToAlwaysCreateNewSagasFor)) {
            return new SagaInitializationPolicy(SagaCreationPolicy.ALWAYS, initialAssociationValue);
        }
        return SagaInitializationPolicy.NONE;
    }

    @Override
    protected Set<AssociationValue> extractAssociationValues(Class<? extends Saga> type, EventMessage event) {
        return this.associationValueResolver.extractAssociationValues(event);
    }

    protected AssociationValue initialAssociationValue(EventMessage event) {
        Set<AssociationValue> associations = this.associationValueResolver.extractAssociationValues(event);
        if (associations.isEmpty()) {
            return null;
        }
        return associations.iterator().next();
    }

    private boolean isAssignableClassIn(Class<?> aClass, Collection<Class<?>> classCollection) {
        for (Class<?> clazz : classCollection) {
            if (aClass == null || !clazz.isAssignableFrom(aClass)) continue;
            return true;
        }
        return false;
    }

    public void setEventsToAlwaysCreateNewSagasFor(List<Class<?>> events) {
        this.eventsToAlwaysCreateNewSagasFor = events;
    }

    public void setEventsToOptionallyCreateNewSagasFor(List<Class<?>> events) {
        this.eventsToOptionallyCreateNewSagasFor = events;
    }

    @Override
    public Class<?> getTargetType() {
        return this.sagaType;
    }
}

