/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.axonframework.saga.ResourceInjector;
import org.axonframework.saga.Saga;
import org.axonframework.saga.SagaFactory;

public class GenericSagaFactory
implements SagaFactory {
    private static final String UNSUITABLE_CTR_MSG = "[%s] is not a suitable type for the GenericSagaFactory. ";
    private ResourceInjector resourceInjector = NullResourceInjector.INSTANCE;

    @Override
    public <T extends Saga> T createSaga(Class<T> sagaType) {
        try {
            Saga instance = (Saga)sagaType.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.resourceInjector.injectResources(instance);
            return (T)instance;
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(String.format("[%s] is not a suitable type for the GenericSagaFactory. It needs an accessible default constructor.", sagaType.getSimpleName()), e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(String.format("[%s] is not a suitable type for the GenericSagaFactory. The default constructor is not accessible.", sagaType.getSimpleName()), e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(String.format("[%s] is not a suitable type for the GenericSagaFactory. An exception occurred while invoking the default constructor.", sagaType.getSimpleName()), e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("[%s] is not a suitable type for the GenericSagaFactory. There must be an accessible default (no-arg) constructor.", sagaType.getSimpleName()), e);
        }
    }

    @Override
    public boolean supports(Class<? extends Saga> sagaType) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = sagaType.getConstructors()) {
            if (constructor.getParameterTypes().length != 0) continue;
            return true;
        }
        return false;
    }

    public void setResourceInjector(ResourceInjector resourceInjector) {
        this.resourceInjector = resourceInjector;
    }

    private static final class NullResourceInjector
    implements ResourceInjector {
        public static final NullResourceInjector INSTANCE = new NullResourceInjector();

        private NullResourceInjector() {
        }

        @Override
        public void injectResources(Saga saga) {
        }
    }
}

