/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.saga;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.axonframework.common.Assert;
import org.axonframework.common.Subscribable;
import org.axonframework.common.lock.IdentifierBasedLock;
import org.axonframework.correlation.CorrelationDataHolder;
import org.axonframework.correlation.CorrelationDataProvider;
import org.axonframework.correlation.MultiCorrelationDataProvider;
import org.axonframework.correlation.SimpleCorrelationDataProvider;
import org.axonframework.domain.EventMessage;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.saga.AbstractReplayAwareSagaManager;
import org.axonframework.saga.AssociationValue;
import org.axonframework.saga.AssociationValues;
import org.axonframework.saga.Saga;
import org.axonframework.saga.SagaCreationPolicy;
import org.axonframework.saga.SagaFactory;
import org.axonframework.saga.SagaInitializationPolicy;
import org.axonframework.saga.SagaRepository;
import org.axonframework.unitofwork.CurrentUnitOfWork;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSagaManager
extends AbstractReplayAwareSagaManager
implements Subscribable {
    private static final Logger logger = LoggerFactory.getLogger(AbstractReplayAwareSagaManager.class);
    private final EventBus eventBus;
    private final SagaRepository sagaRepository;
    private final SagaFactory sagaFactory;
    private final Class<? extends Saga>[] sagaTypes;
    private final IdentifierBasedLock lock = new IdentifierBasedLock();
    private final Map<String, Saga> sagasInCreation = new ConcurrentHashMap<String, Saga>();
    private volatile boolean suppressExceptions = true;
    private volatile boolean synchronizeSagaAccess = true;
    private CorrelationDataProvider<? super EventMessage> correlationDataProvider = new SimpleCorrelationDataProvider(new String[0]);

    @Deprecated
    public AbstractSagaManager(EventBus eventBus, SagaRepository sagaRepository, SagaFactory sagaFactory, Class<? extends Saga> ... sagaTypes) {
        Assert.notNull(eventBus, "eventBus may not be null");
        Assert.notNull(sagaRepository, "sagaRepository may not be null");
        Assert.notNull(sagaFactory, "sagaFactory may not be null");
        this.eventBus = eventBus;
        this.sagaRepository = sagaRepository;
        this.sagaFactory = sagaFactory;
        this.sagaTypes = sagaTypes;
    }

    public AbstractSagaManager(SagaRepository sagaRepository, SagaFactory sagaFactory, Class<? extends Saga> ... sagaTypes) {
        Assert.notNull(sagaRepository, "sagaRepository may not be null");
        Assert.notNull(sagaFactory, "sagaFactory may not be null");
        this.eventBus = null;
        this.sagaRepository = sagaRepository;
        this.sagaFactory = sagaFactory;
        this.sagaTypes = sagaTypes;
    }

    @Override
    public void handle(EventMessage event) {
        for (Class<? extends Saga> sagaType : this.sagaTypes) {
            Set<AssociationValue> associationValues = this.extractAssociationValues(sagaType, event);
            if (associationValues == null || associationValues.isEmpty()) continue;
            boolean sagaOfTypeInvoked = this.invokeExistingSagas(event, sagaType, associationValues);
            SagaInitializationPolicy initializationPolicy = this.getSagaCreationPolicy(sagaType, event);
            if (initializationPolicy.getCreationPolicy() != SagaCreationPolicy.ALWAYS && (sagaOfTypeInvoked || initializationPolicy.getCreationPolicy() != SagaCreationPolicy.IF_NONE_FOUND)) continue;
            this.startNewSaga(event, sagaType, initializationPolicy.getInitialAssociationValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeExistingSagas(EventMessage event, Class<? extends Saga> sagaType, Collection<AssociationValue> associationValues) {
        TreeSet<String> sagas = new TreeSet<String>();
        for (AssociationValue associationValue : associationValues) {
            sagas.addAll(this.sagaRepository.find(sagaType, associationValue));
        }
        for (Saga sagaInCreation : this.sagasInCreation.values()) {
            if (!sagaType.isInstance(sagaInCreation) || !this.containsAny(sagaInCreation.getAssociationValues(), associationValues)) continue;
            sagas.add(sagaInCreation.getSagaIdentifier());
        }
        boolean sagaOfTypeInvoked = false;
        for (String sagaId : sagas) {
            if (this.synchronizeSagaAccess) {
                this.lock.obtainLock(sagaId);
                Saga invokedSaga = null;
                try {
                    invokedSaga = this.loadAndInvoke(event, sagaId, associationValues);
                    if (invokedSaga == null) continue;
                    sagaOfTypeInvoked = true;
                    continue;
                }
                finally {
                    this.doReleaseLock(sagaId, invokedSaga);
                    continue;
                }
            }
            this.loadAndInvoke(event, sagaId, associationValues);
        }
        return sagaOfTypeInvoked;
    }

    private boolean containsAny(AssociationValues associationValues, Collection<AssociationValue> toFind) {
        for (AssociationValue valueToFind : toFind) {
            if (!associationValues.contains(valueToFind)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startNewSaga(EventMessage event, Class<? extends Saga> sagaType, AssociationValue associationValue) {
        block15: {
            Saga newSaga = this.sagaFactory.createSaga(sagaType);
            newSaga.getAssociationValues().add(associationValue);
            this.preProcessSaga(newSaga);
            this.sagasInCreation.put(newSaga.getSagaIdentifier(), newSaga);
            try {
                if (this.synchronizeSagaAccess) {
                    this.lock.obtainLock(newSaga.getSagaIdentifier());
                    try {
                        this.doInvokeSaga(event, newSaga);
                        break block15;
                    }
                    finally {
                        try {
                            this.sagaRepository.add(newSaga);
                        }
                        finally {
                            this.doReleaseLock(newSaga.getSagaIdentifier(), newSaga);
                        }
                    }
                }
                try {
                    this.doInvokeSaga(event, newSaga);
                }
                finally {
                    this.sagaRepository.add(newSaga);
                }
            }
            finally {
                this.removeEntry(newSaga.getSagaIdentifier(), this.sagasInCreation);
            }
        }
    }

    private void doReleaseLock(String sagaId, final Saga sagaInstance) {
        if (sagaInstance == null || !CurrentUnitOfWork.isStarted()) {
            this.lock.releaseLock(sagaId);
        } else if (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().registerListener(new UnitOfWorkListenerAdapter(){

                @Override
                public void onCleanup(UnitOfWork unitOfWork) {
                    AbstractSagaManager.this.lock.releaseLock(sagaInstance.getSagaIdentifier());
                }
            });
        }
    }

    private void removeEntry(final String sagaIdentifier, final Map<String, ?> sagaMap) {
        if (!CurrentUnitOfWork.isStarted()) {
            sagaMap.remove(sagaIdentifier);
        } else {
            CurrentUnitOfWork.get().registerListener(new UnitOfWorkListenerAdapter(){

                @Override
                public void afterCommit(UnitOfWork unitOfWork) {
                    sagaMap.remove(sagaIdentifier);
                }
            });
        }
    }

    protected abstract SagaInitializationPolicy getSagaCreationPolicy(Class<? extends Saga> var1, EventMessage var2);

    protected abstract Set<AssociationValue> extractAssociationValues(Class<? extends Saga> var1, EventMessage var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Saga loadAndInvoke(EventMessage event, String sagaId, Collection<AssociationValue> associations) {
        Saga saga = this.sagasInCreation.get(sagaId);
        if (saga == null) {
            saga = this.sagaRepository.load(sagaId);
        }
        if (saga == null || !saga.isActive() || !this.containsAny(saga.getAssociationValues(), associations)) {
            return null;
        }
        this.preProcessSaga(saga);
        try {
            this.doInvokeSaga(event, saga);
        }
        finally {
            this.commit(saga);
        }
        return saga;
    }

    protected void preProcessSaga(Saga saga) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInvokeSaga(EventMessage event, Saga saga) {
        block6: {
            try {
                CorrelationDataHolder.setCorrelationData(this.correlationDataProvider.correlationDataFor(event));
                saga.handle(event);
            }
            catch (RuntimeException e) {
                if (this.suppressExceptions) {
                    logger.error(String.format("An exception occurred while a Saga [%s] was handling an Event [%s]:", saga.getClass().getSimpleName(), event.getPayloadType().getSimpleName()), (Throwable)e);
                    break block6;
                }
                throw e;
            }
            finally {
                CorrelationDataHolder.clear();
            }
        }
    }

    protected void commit(Saga saga) {
        this.sagaRepository.commit(saga);
    }

    @Override
    @PreDestroy
    @Deprecated
    public void unsubscribe() {
        if (this.eventBus != null) {
            this.eventBus.unsubscribe(this);
        }
    }

    @Override
    @PostConstruct
    @Deprecated
    public void subscribe() {
        if (this.eventBus != null) {
            this.eventBus.subscribe(this);
        }
    }

    public void setSuppressExceptions(boolean suppressExceptions) {
        this.suppressExceptions = suppressExceptions;
    }

    public void setSynchronizeSagaAccess(boolean synchronizeSagaAccess) {
        this.synchronizeSagaAccess = synchronizeSagaAccess;
    }

    public void setCorrelationDataProvider(CorrelationDataProvider<? super EventMessage> correlationDataProvider) {
        this.correlationDataProvider = correlationDataProvider;
    }

    public void setCorrelationDataProviders(List<? extends CorrelationDataProvider<? super EventMessage>> correlationDataProviders) {
        this.correlationDataProvider = new MultiCorrelationDataProvider<EventMessage>(correlationDataProviders);
    }

    public Set<Class<? extends Saga>> getManagedSagaTypes() {
        return new LinkedHashSet<Class<? extends Saga>>(Arrays.asList(this.sagaTypes));
    }
}

