/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.repository;

import javax.persistence.EntityManager;
import org.axonframework.common.Assert;
import org.axonframework.common.jpa.EntityManagerProvider;
import org.axonframework.common.jpa.SimpleEntityManagerProvider;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.repository.AggregateNotFoundException;
import org.axonframework.repository.ConflictingAggregateVersionException;
import org.axonframework.repository.LockManager;
import org.axonframework.repository.LockingRepository;
import org.axonframework.repository.NullLockManager;

public class GenericJpaRepository<T extends AggregateRoot>
extends LockingRepository<T> {
    private final EntityManagerProvider entityManagerProvider;
    private boolean forceFlushOnSave = true;

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType) {
        this(entityManagerProvider, aggregateType, (LockManager)new NullLockManager());
    }

    public GenericJpaRepository(EntityManager entityManager, Class<T> aggregateType) {
        this(new SimpleEntityManagerProvider(entityManager), aggregateType, (LockManager)new NullLockManager());
    }

    public GenericJpaRepository(EntityManagerProvider entityManagerProvider, Class<T> aggregateType, LockManager lockManager) {
        super(aggregateType, lockManager);
        Assert.notNull(entityManagerProvider, "entityManagerProvider may not be null");
        this.entityManagerProvider = entityManagerProvider;
    }

    public GenericJpaRepository(EntityManager entityManager, Class<T> aggregateType, LockManager lockManager) {
        super(aggregateType, lockManager);
        this.entityManagerProvider = new SimpleEntityManagerProvider(entityManager);
    }

    @Override
    protected void doSaveWithLock(T aggregate) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        entityManager.persist(aggregate);
        if (this.forceFlushOnSave) {
            entityManager.flush();
        }
    }

    @Override
    protected void doDeleteWithLock(T aggregate) {
        EntityManager entityManager = this.entityManagerProvider.getEntityManager();
        entityManager.remove(aggregate);
        if (this.forceFlushOnSave) {
            entityManager.flush();
        }
    }

    @Override
    protected T doLoad(Object aggregateIdentifier, Long expectedVersion) {
        AggregateRoot aggregate = (AggregateRoot)this.entityManagerProvider.getEntityManager().find(this.getAggregateType(), aggregateIdentifier);
        if (aggregate == null) {
            throw new AggregateNotFoundException(aggregateIdentifier, String.format("Aggregate [%s] with identifier [%s] not found", this.getAggregateType().getSimpleName(), aggregateIdentifier));
        }
        if (expectedVersion != null && aggregate.getVersion() != null && !expectedVersion.equals(aggregate.getVersion())) {
            throw new ConflictingAggregateVersionException(aggregateIdentifier, expectedVersion, aggregate.getVersion());
        }
        return (T)aggregate;
    }

    public void setForceFlushOnSave(boolean forceFlushOnSave) {
        this.forceFlushOnSave = forceFlushOnSave;
    }
}

