/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.repository;

import org.axonframework.common.Assert;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.repository.ConflictingAggregateVersionException;
import org.axonframework.repository.Repository;
import org.axonframework.unitofwork.CurrentUnitOfWork;
import org.axonframework.unitofwork.SaveAggregateCallback;

public abstract class AbstractRepository<T extends AggregateRoot>
implements Repository<T> {
    private final Class<T> aggregateType;
    private final SimpleSaveAggregateCallback saveAggregateCallback = new SimpleSaveAggregateCallback();
    private EventBus eventBus;

    protected AbstractRepository(Class<T> aggregateType) {
        Assert.notNull(aggregateType, "aggregateType may not be null");
        this.aggregateType = aggregateType;
    }

    @Override
    public void add(T aggregate) {
        Assert.isTrue(this.aggregateType.isInstance(aggregate), "Unsuitable aggregate for this repository: wrong type");
        if (aggregate.getVersion() != null) {
            throw new IllegalArgumentException("Only newly created (unpersisted) aggregates may be added.");
        }
        CurrentUnitOfWork.get().registerAggregate(aggregate, this.eventBus, this.saveAggregateCallback);
    }

    @Override
    public T load(Object aggregateIdentifier, Long expectedVersion) {
        T aggregate = this.doLoad(aggregateIdentifier, expectedVersion);
        this.validateOnLoad(aggregate, expectedVersion);
        return CurrentUnitOfWork.get().registerAggregate(aggregate, this.eventBus, this.saveAggregateCallback);
    }

    @Override
    public T load(Object aggregateIdentifier) {
        return (T)this.load(aggregateIdentifier, null);
    }

    protected void validateOnLoad(T aggregate, Long expectedVersion) {
        if (expectedVersion != null && aggregate.getVersion() != null && !expectedVersion.equals(aggregate.getVersion())) {
            throw new ConflictingAggregateVersionException(aggregate.getIdentifier(), expectedVersion, aggregate.getVersion());
        }
    }

    protected Class<T> getAggregateType() {
        return this.aggregateType;
    }

    protected abstract void doSave(T var1);

    protected abstract T doLoad(Object var1, Long var2);

    protected abstract void doDelete(T var1);

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    protected void postSave(T aggregate) {
    }

    protected void postDelete(T aggregate) {
    }

    private class SimpleSaveAggregateCallback
    implements SaveAggregateCallback<T> {
        private SimpleSaveAggregateCallback() {
        }

        @Override
        public void save(T aggregate) {
            if (aggregate.isDeleted()) {
                AbstractRepository.this.doDelete(aggregate);
            } else {
                AbstractRepository.this.doSave(aggregate);
            }
            aggregate.commitEvents();
            if (aggregate.isDeleted()) {
                AbstractRepository.this.postDelete(aggregate);
            } else {
                AbstractRepository.this.postSave(aggregate);
            }
        }
    }
}

