/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.monitoring;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MonitorRegistry {
    private static final Logger logger = LoggerFactory.getLogger(MonitorRegistry.class);
    private static final List<MonitorRegistry> registries = new ArrayList<MonitorRegistry>();

    public static void registerMonitoringBean(Object monitoringBean, Class<?> componentType) {
        for (MonitorRegistry registry : registries) {
            try {
                registry.registerBean(monitoringBean, componentType);
            }
            catch (Exception e) {
                logger.warn("Exception when registering {} with {} ", new Object[]{monitoringBean, registry, e});
            }
            catch (Error e) {
                logger.warn("Error when registering {} with {} ", new Object[]{monitoringBean, registry, e});
            }
        }
    }

    protected abstract void registerBean(Object var1, Class<?> var2);

    static {
        ServiceLoader<MonitorRegistry> registryLoader = ServiceLoader.load(MonitorRegistry.class);
        for (MonitorRegistry monitorRegistry : registryLoader) {
            registries.add(monitorRegistry);
        }
    }
}

