/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.supporting;

import java.io.Closeable;
import java.io.IOException;
import org.axonframework.common.io.IOUtils;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.eventstore.EventStore;
import org.axonframework.eventstore.EventVisitor;
import org.axonframework.eventstore.management.Criteria;
import org.axonframework.eventstore.management.CriteriaBuilder;
import org.axonframework.eventstore.management.EventStoreManagement;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class TimestampCutoffReadonlyEventStore
implements EventStore,
EventStoreManagement {
    private final EventStore backend;
    private final EventStoreManagement backendManagement;
    private final DateTime cutoffTimestamp;

    public TimestampCutoffReadonlyEventStore(EventStore backend, EventStoreManagement backendManagement, DateTime snapshotTimestamp) {
        this.backend = backend;
        this.backendManagement = backendManagement;
        this.cutoffTimestamp = snapshotTimestamp;
    }

    @Override
    public void visitEvents(EventVisitor visitor) {
        this.backendManagement.visitEvents(TimestampCutoffReadonlyEventStore.cutOffEventVisitor(visitor, this.cutoffTimestamp));
    }

    private static EventVisitor cutOffEventVisitor(final EventVisitor visitor, final DateTime snapshotTimestamp) {
        return new EventVisitor(){

            @Override
            public void doWithEvent(DomainEventMessage domainEvent) {
                if (domainEvent.getTimestamp().isBefore((ReadableInstant)snapshotTimestamp)) {
                    visitor.doWithEvent(domainEvent);
                }
            }
        };
    }

    @Override
    public void visitEvents(Criteria criteria, EventVisitor visitor) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public CriteriaBuilder newCriteriaBuilder() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public void appendEvents(String type, DomainEventStream events) {
        throw new IllegalStateException("Not allowed to append events to " + this.getClass() + ". Not appending events on aggregate " + type);
    }

    @Override
    public DomainEventStream readEvents(String type, Object identifier) {
        DomainEventStream backendEvents = this.backend.readEvents(type, identifier);
        return this.cutOff(backendEvents);
    }

    private DomainEventStream cutOff(DomainEventStream events) {
        return new TimestampCutOffDomainEventStream(events, this.cutoffTimestamp);
    }

    private static final class TimestampCutOffDomainEventStream
    implements DomainEventStream,
    Closeable {
        private final DateTime timeStampCutOff;
        private final DomainEventStream events;
        private DomainEventMessage next;

        public TimestampCutOffDomainEventStream(DomainEventStream events, DateTime timeStampCutOff) {
            this.events = events;
            this.timeStampCutOff = timeStampCutOff;
            this.next = this.findNextItem();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public synchronized DomainEventMessage next() {
            DomainEventMessage current = this.next;
            this.next = this.findNextItem();
            return current;
        }

        private DomainEventMessage findNextItem() {
            DomainEventMessage retval = null;
            while (retval == null && this.events.hasNext()) {
                DomainEventMessage candidate = this.events.next();
                if (candidate.getTimestamp().isBefore((ReadableInstant)this.timeStampCutOff)) {
                    retval = candidate;
                    continue;
                }
                retval = null;
            }
            return retval;
        }

        @Override
        public DomainEventMessage peek() {
            return this.next;
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeIfCloseable(this.events);
        }
    }
}

