/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.jpa;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.eventstore.jpa.DefaultEventEntryFactory;
import org.axonframework.eventstore.jpa.EventEntryFactory;
import org.axonframework.eventstore.jpa.EventEntryStore;
import org.axonframework.eventstore.jpa.SimpleSerializedDomainEventData;
import org.axonframework.serializer.SerializedDomainEventData;
import org.axonframework.serializer.SerializedObject;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventEntryStore<T>
implements EventEntryStore<T> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultEventEntryStore.class);
    private final EventEntryFactory<T> eventEntryFactory;

    public DefaultEventEntryStore() {
        this(false);
    }

    public DefaultEventEntryStore(boolean forceUtcTimestamp) {
        this(new DefaultEventEntryFactory(forceUtcTimestamp));
    }

    public DefaultEventEntryStore(EventEntryFactory<T> eventEntryFactory) {
        this.eventEntryFactory = eventEntryFactory;
    }

    @Override
    public void persistEvent(String aggregateType, DomainEventMessage event, SerializedObject<T> serializedPayload, SerializedObject<T> serializedMetaData, EntityManager entityManager) {
        entityManager.persist(this.createDomainEventEntry(aggregateType, event, serializedPayload, serializedMetaData));
    }

    public SimpleSerializedDomainEventData loadLastSnapshotEvent(String aggregateType, Object identifier, EntityManager entityManager) {
        List entries = entityManager.createQuery("SELECT new org.axonframework.eventstore.jpa.SimpleSerializedDomainEventData(e.eventIdentifier, e.aggregateIdentifier, e.sequenceNumber, e.timeStamp, e.payloadType, e.payloadRevision, e.payload, e.metaData) FROM " + this.snapshotEventEntryEntityName() + " e " + "WHERE e.aggregateIdentifier = :id AND e.type = :type " + "ORDER BY e.sequenceNumber DESC").setParameter("id", (Object)identifier.toString()).setParameter("type", (Object)aggregateType).setMaxResults(1).setFirstResult(0).getResultList();
        if (entries.size() < 1) {
            return null;
        }
        return (SimpleSerializedDomainEventData)entries.get(0);
    }

    @Override
    public Iterator<SerializedDomainEventData<T>> fetchFiltered(String whereClause, Map<String, Object> parameters, int batchSize, EntityManager entityManager) {
        return new BatchingIterator<T>(whereClause, parameters, batchSize, this.domainEventEntryEntityName(), this.eventEntryFactory, entityManager);
    }

    @Override
    public void persistSnapshot(String aggregateType, DomainEventMessage snapshotEvent, SerializedObject<T> serializedPayload, SerializedObject<T> serializedMetaData, EntityManager entityManager) {
        entityManager.persist(this.createSnapshotEventEntry(aggregateType, snapshotEvent, serializedPayload, serializedMetaData));
    }

    @Override
    public Class<T> getDataType() {
        return this.eventEntryFactory.getDataType();
    }

    protected Object createDomainEventEntry(String aggregateType, DomainEventMessage event, SerializedObject<T> serializedPayload, SerializedObject<T> serializedMetaData) {
        return this.eventEntryFactory.createDomainEventEntry(aggregateType, event, serializedPayload, serializedMetaData);
    }

    protected Object createSnapshotEventEntry(String aggregateType, DomainEventMessage snapshotEvent, SerializedObject<T> serializedPayload, SerializedObject<T> serializedMetaData) {
        return this.eventEntryFactory.createSnapshotEventEntry(aggregateType, snapshotEvent, serializedPayload, serializedMetaData);
    }

    protected String domainEventEntryEntityName() {
        return this.eventEntryFactory.getDomainEventEntryEntityName();
    }

    protected String snapshotEventEntryEntityName() {
        return this.eventEntryFactory.getSnapshotEventEntryEntityName();
    }

    @Override
    public void pruneSnapshots(String type, DomainEventMessage mostRecentSnapshotEvent, int maxSnapshotsArchived, EntityManager entityManager) {
        Iterator<Long> redundantSnapshots = this.findRedundantSnapshots(type, mostRecentSnapshotEvent, maxSnapshotsArchived, entityManager);
        if (redundantSnapshots.hasNext()) {
            Long sequenceOfFirstSnapshotToPrune = redundantSnapshots.next();
            entityManager.createQuery("DELETE FROM " + this.snapshotEventEntryEntityName() + " e " + "WHERE e.type = :type " + "AND e.aggregateIdentifier = :aggregateIdentifier " + "AND e.sequenceNumber <= :sequenceOfFirstSnapshotToPrune").setParameter("type", (Object)type).setParameter("aggregateIdentifier", (Object)mostRecentSnapshotEvent.getAggregateIdentifier().toString()).setParameter("sequenceOfFirstSnapshotToPrune", (Object)sequenceOfFirstSnapshotToPrune).executeUpdate();
        }
    }

    private Iterator<Long> findRedundantSnapshots(String type, DomainEventMessage snapshotEvent, int maxSnapshotsArchived, EntityManager entityManager) {
        return entityManager.createQuery("SELECT e.sequenceNumber FROM " + this.snapshotEventEntryEntityName() + " e " + "WHERE e.type = :type AND e.aggregateIdentifier = :aggregateIdentifier " + "ORDER BY e.sequenceNumber DESC").setParameter("type", (Object)type).setParameter("aggregateIdentifier", (Object)snapshotEvent.getAggregateIdentifier().toString()).setFirstResult(maxSnapshotsArchived).setMaxResults(1).getResultList().iterator();
    }

    @Override
    public Iterator<SerializedDomainEventData<T>> fetchAggregateStream(String aggregateType, Object identifier, long firstSequenceNumber, int batchSize, EntityManager entityManager) {
        return new BatchingAggregateStreamIterator(firstSequenceNumber, identifier, aggregateType, batchSize, this.domainEventEntryEntityName(), entityManager);
    }

    private static class BatchingIterator<T>
    implements Iterator<SerializedDomainEventData<T>> {
        private final String whereClause;
        private final Map<String, Object> parameters;
        private final int batchSize;
        private final String domainEventEntryEntityName;
        private final EntityManager entityManager;
        private final EventEntryFactory<T> eventEntryFactory;
        private int currentBatchSize;
        private Iterator<SerializedDomainEventData<T>> currentBatch;
        private SerializedDomainEventData<T> next;
        private SerializedDomainEventData<T> lastItem;

        public BatchingIterator(String whereClause, Map<String, Object> parameters, int batchSize, String domainEventEntryEntityName, EventEntryFactory<T> eventEntryFactory, EntityManager entityManager) {
            this.whereClause = whereClause;
            this.parameters = parameters;
            this.batchSize = batchSize;
            this.domainEventEntryEntityName = domainEventEntryEntityName;
            this.eventEntryFactory = eventEntryFactory;
            this.entityManager = entityManager;
            List<SerializedDomainEventData<T>> firstBatch = this.fetchBatch();
            this.currentBatchSize = firstBatch.size();
            this.currentBatch = firstBatch.iterator();
            if (this.currentBatch.hasNext()) {
                this.next = this.currentBatch.next();
            }
        }

        private List<SerializedDomainEventData<T>> fetchBatch() {
            HashMap<String, Object> params = new HashMap<String, Object>(this.parameters);
            Query query = this.entityManager.createQuery(String.format("SELECT new org.axonframework.eventstore.jpa.SimpleSerializedDomainEventData(e.eventIdentifier, e.aggregateIdentifier, e.sequenceNumber, e.timeStamp, e.payloadType, e.payloadRevision, e.payload, e.metaData) FROM " + this.domainEventEntryEntityName + " e %s ORDER BY e.timeStamp ASC, " + "e.sequenceNumber ASC, e.aggregateIdentifier ASC", this.buildWhereClause(params))).setMaxResults(this.batchSize);
            for (Map.Entry entry : params.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof DateTime) {
                    value = this.eventEntryFactory.resolveDateTimeValue((DateTime)entry.getValue());
                }
                query.setParameter((String)entry.getKey(), value);
            }
            List resultList = query.getResultList();
            if (!resultList.isEmpty()) {
                this.lastItem = (SerializedDomainEventData)resultList.get(resultList.size() - 1);
            }
            return resultList;
        }

        private String buildWhereClause(Map<String, Object> paramRegistry) {
            if (this.lastItem == null && this.whereClause == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder("WHERE ");
            if (this.lastItem != null) {
                sb.append("((").append("e.timeStamp > :timestamp").append(") OR (").append("e.timeStamp = :timestamp AND e.sequenceNumber > :sequenceNumber").append(") OR (").append("e.timeStamp = :timestamp AND e.sequenceNumber = :sequenceNumber AND ").append("e.aggregateIdentifier > :aggregateIdentifier))");
                paramRegistry.put("timestamp", this.lastItem.getTimestamp());
                paramRegistry.put("sequenceNumber", this.lastItem.getSequenceNumber());
                paramRegistry.put("aggregateIdentifier", this.lastItem.getAggregateIdentifier());
            }
            if (this.whereClause != null && this.whereClause.length() > 0) {
                if (this.lastItem != null) {
                    sb.append(" AND (");
                }
                sb.append(this.whereClause);
                if (this.lastItem != null) {
                    sb.append(")");
                }
            }
            return sb.toString();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public SerializedDomainEventData<T> next() {
            SerializedDomainEventData<T> current = this.next;
            if (this.next != null && !this.currentBatch.hasNext() && this.currentBatchSize >= this.batchSize) {
                List<SerializedDomainEventData<T>> entries = this.fetchBatch();
                this.currentBatchSize = entries.size();
                this.currentBatch = entries.iterator();
            }
            this.next = this.currentBatch.hasNext() ? this.currentBatch.next() : null;
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported");
        }
    }

    private static final class BatchingAggregateStreamIterator<T>
    implements Iterator<SerializedDomainEventData<T>> {
        private final Object id;
        private final String typeId;
        private final int batchSize;
        private final String domainEventEntryEntityName;
        private final EntityManager entityManager;
        private int currentBatchSize;
        private Iterator<SerializedDomainEventData<T>> currentBatch;
        private SerializedDomainEventData<T> next;

        private BatchingAggregateStreamIterator(long firstSequenceNumber, Object id, String typeId, int batchSize, String domainEventEntryEntityName, EntityManager entityManager) {
            this.id = id;
            this.typeId = typeId;
            this.batchSize = batchSize;
            this.domainEventEntryEntityName = domainEventEntryEntityName;
            this.entityManager = entityManager;
            List<SerializedDomainEventData<T>> firstBatch = this.fetchBatch(firstSequenceNumber);
            this.currentBatchSize = firstBatch.size();
            this.currentBatch = firstBatch.iterator();
            if (this.currentBatch.hasNext()) {
                this.next = this.currentBatch.next();
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public SerializedDomainEventData<T> next() {
            SerializedDomainEventData<T> current = this.next;
            if (this.next != null && !this.currentBatch.hasNext() && this.currentBatchSize >= this.batchSize) {
                logger.debug("Fetching new batch for Aggregate [{}]", this.id);
                List<SerializedDomainEventData<T>> entries = this.fetchBatch(this.next.getSequenceNumber() + 1L);
                this.currentBatchSize = entries.size();
                this.currentBatch = entries.iterator();
            }
            this.next = this.currentBatch.hasNext() ? this.currentBatch.next() : null;
            return current;
        }

        private List<SerializedDomainEventData<T>> fetchBatch(long firstSequenceNumber) {
            return this.entityManager.createQuery("SELECT new org.axonframework.eventstore.jpa.SimpleSerializedDomainEventData(e.eventIdentifier, e.aggregateIdentifier, e.sequenceNumber, e.timeStamp, e.payloadType, e.payloadRevision, e.payload, e.metaData) FROM " + this.domainEventEntryEntityName + " e " + "WHERE e.aggregateIdentifier = :id AND e.type = :type " + "AND e.sequenceNumber >= :seq " + "ORDER BY e.sequenceNumber ASC").setParameter("id", (Object)this.id.toString()).setParameter("type", (Object)this.typeId).setParameter("seq", (Object)firstSequenceNumber).setMaxResults(this.batchSize).getResultList();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported");
        }
    }
}

