/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.jpa;

import org.axonframework.domain.DomainEventMessage;
import org.axonframework.eventstore.jpa.DomainEventEntry;
import org.axonframework.eventstore.jpa.EventEntryFactory;
import org.axonframework.eventstore.jpa.SnapshotEventEntry;
import org.axonframework.serializer.SerializedObject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class DefaultEventEntryFactory
implements EventEntryFactory<byte[]> {
    private final boolean forceUtc;

    public DefaultEventEntryFactory() {
        this(false);
    }

    public DefaultEventEntryFactory(boolean forceUtc) {
        this.forceUtc = forceUtc;
    }

    @Override
    public Class<byte[]> getDataType() {
        return byte[].class;
    }

    @Override
    public Object createDomainEventEntry(String aggregateType, DomainEventMessage event, SerializedObject<byte[]> serializedPayload, SerializedObject<byte[]> serializedMetaData) {
        DateTime timestamp = event.getTimestamp();
        if (this.forceUtc) {
            timestamp = event.getTimestamp().toDateTime(DateTimeZone.UTC);
        }
        return new DomainEventEntry(aggregateType, event, timestamp, serializedPayload, serializedMetaData);
    }

    @Override
    public Object createSnapshotEventEntry(String aggregateType, DomainEventMessage snapshotEvent, SerializedObject<byte[]> serializedPayload, SerializedObject<byte[]> serializedMetaData) {
        return new SnapshotEventEntry(aggregateType, snapshotEvent, serializedPayload, serializedMetaData);
    }

    @Override
    public String getDomainEventEntryEntityName() {
        return "DomainEventEntry";
    }

    @Override
    public String getSnapshotEventEntryEntityName() {
        return "SnapshotEventEntry";
    }

    @Override
    public String resolveDateTimeValue(DateTime dateTime) {
        return dateTime.toString();
    }
}

