/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.jpa;

import java.io.Serializable;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.MappedSuperclass;
import org.axonframework.serializer.SerializedDomainEventData;
import org.axonframework.serializer.SerializedType;
import org.axonframework.serializer.SimpleSerializedType;
import org.joda.time.DateTime;

@MappedSuperclass
@IdClass(value=PK.class)
public abstract class AbstractEventEntryData<T>
implements SerializedDomainEventData<T> {
    @Id
    private String type;
    @Id
    private String aggregateIdentifier;
    @Id
    private long sequenceNumber;
    @Column(nullable=false, unique=true)
    private String eventIdentifier;
    @Basic(optional=false)
    private String timeStamp;
    @Basic(optional=false)
    private String payloadType;
    @Basic
    private String payloadRevision;

    public AbstractEventEntryData(String eventIdentifier, String type, String aggregateIdentifier, long sequenceNumber, DateTime timestamp, SerializedType payloadType) {
        this.eventIdentifier = eventIdentifier;
        this.type = type;
        this.payloadType = payloadType.getName();
        this.payloadRevision = payloadType.getRevision();
        this.aggregateIdentifier = aggregateIdentifier;
        this.sequenceNumber = sequenceNumber;
        this.timeStamp = timestamp.toString();
    }

    protected AbstractEventEntryData() {
    }

    @Override
    public String getEventIdentifier() {
        return this.eventIdentifier;
    }

    @Override
    public Object getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public DateTime getTimestamp() {
        return new DateTime((Object)this.timeStamp);
    }

    protected SerializedType getPayloadType() {
        return new SimpleSerializedType(this.payloadType, this.payloadRevision);
    }

    public static class PK
    implements Serializable {
        private static final long serialVersionUID = 9182347799552520594L;
        private String aggregateIdentifier;
        private String type;
        private long sequenceNumber;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PK pk = (PK)o;
            if (this.sequenceNumber != pk.sequenceNumber) {
                return false;
            }
            if (!this.aggregateIdentifier.equals(pk.aggregateIdentifier)) {
                return false;
            }
            return this.type.equals(pk.type);
        }

        public int hashCode() {
            int result = this.aggregateIdentifier.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + (int)(this.sequenceNumber ^ this.sequenceNumber >>> 32);
            return result;
        }

        public String toString() {
            return "PK{type='" + this.type + '\'' + ", aggregateIdentifier='" + this.aggregateIdentifier + '\'' + ", sequenceNumber=" + this.sequenceNumber + '}';
        }
    }
}

