/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.jpa;

import java.util.Arrays;
import javax.persistence.Basic;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.eventstore.jpa.AbstractEventEntryData;
import org.axonframework.serializer.SerializedMetaData;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.SimpleSerializedObject;
import org.joda.time.DateTime;

@MappedSuperclass
public abstract class AbstractEventEntry
extends AbstractEventEntryData<byte[]> {
    @Basic
    @Lob
    private byte[] metaData;
    @Basic(optional=false)
    @Lob
    private byte[] payload;

    protected AbstractEventEntry(String type, DomainEventMessage event, SerializedObject<byte[]> payload, SerializedObject<byte[]> metaData) {
        this(type, event, event.getTimestamp(), payload, metaData);
    }

    protected AbstractEventEntry(String type, DomainEventMessage event, DateTime timestamp, SerializedObject<byte[]> payload, SerializedObject<byte[]> metaData) {
        super(event.getIdentifier(), type, event.getAggregateIdentifier().toString(), event.getSequenceNumber(), timestamp, payload.getType());
        this.metaData = Arrays.copyOf(metaData.getData(), metaData.getData().length);
        this.payload = payload.getData();
    }

    protected AbstractEventEntry() {
    }

    @Override
    public SerializedObject<byte[]> getPayload() {
        return new SimpleSerializedObject<byte[]>(this.payload, byte[].class, this.getPayloadType());
    }

    @Override
    public SerializedObject<byte[]> getMetaData() {
        return new SerializedMetaData<byte[]>(this.metaData, byte[].class);
    }
}

