/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.jdbc.criteria;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.axonframework.eventstore.jdbc.criteria.JdbcCriteria;
import org.axonframework.eventstore.jdbc.criteria.JdbcProperty;
import org.axonframework.eventstore.jdbc.criteria.ParameterRegistry;

public class CollectionOperator
extends JdbcCriteria {
    private final JdbcProperty property;
    private final Object expression;
    private final String operator;

    public CollectionOperator(JdbcProperty property, String operator, Object expression) {
        this.property = property;
        this.expression = expression;
        this.operator = operator;
    }

    @Override
    public void parse(String entryKey, StringBuilder whereClause, ParameterRegistry parameters) {
        this.property.parse(entryKey, whereClause);
        whereClause.append(" ").append(this.operator).append(" ");
        if (this.expression instanceof JdbcProperty) {
            ((JdbcProperty)this.expression).parse(entryKey, whereClause);
        } else {
            Iterator<?> iterator = CollectionOperator.getIteratorFor(this.expression);
            whereClause.append("(");
            while (iterator.hasNext()) {
                whereClause.append(parameters.register(iterator.next()));
                if (!iterator.hasNext()) continue;
                whereClause.append(",");
            }
            whereClause.append(")");
        }
    }

    private static Iterator<?> getIteratorFor(Object object) {
        if (object == null) {
            return Collections.singleton(null).iterator();
        }
        if (object.getClass().isArray()) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (int i = 0; i < Array.getLength(object); ++i) {
                result.add(Array.get(object, i));
            }
            return result.iterator();
        }
        if (object instanceof Iterable) {
            return ((Iterable)object).iterator();
        }
        return Collections.singleton(object).iterator();
    }
}

