/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.jdbc;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.axonframework.common.Assert;
import org.axonframework.common.IdentifierValidator;
import org.axonframework.common.io.IOUtils;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.DataSourceConnectionProvider;
import org.axonframework.common.jdbc.PersistenceExceptionResolver;
import org.axonframework.common.jdbc.UnitOfWorkAwareConnectionProviderWrapper;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.domain.GenericDomainEventMessage;
import org.axonframework.eventstore.EventStreamNotFoundException;
import org.axonframework.eventstore.EventVisitor;
import org.axonframework.eventstore.PartialStreamSupport;
import org.axonframework.eventstore.SnapshotEventStore;
import org.axonframework.eventstore.jdbc.DefaultEventEntryStore;
import org.axonframework.eventstore.jdbc.EventEntryStore;
import org.axonframework.eventstore.jdbc.JdbcSQLErrorCodesResolver;
import org.axonframework.eventstore.jdbc.criteria.JdbcCriteria;
import org.axonframework.eventstore.jdbc.criteria.JdbcCriteriaBuilder;
import org.axonframework.eventstore.jdbc.criteria.ParameterRegistry;
import org.axonframework.eventstore.management.Criteria;
import org.axonframework.eventstore.management.CriteriaBuilder;
import org.axonframework.eventstore.management.EventStoreManagement;
import org.axonframework.repository.ConcurrencyException;
import org.axonframework.serializer.MessageSerializer;
import org.axonframework.serializer.SerializedDomainEventData;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.Serializer;
import org.axonframework.serializer.xml.XStreamSerializer;
import org.axonframework.upcasting.SimpleUpcasterChain;
import org.axonframework.upcasting.UpcastUtils;
import org.axonframework.upcasting.UpcasterAware;
import org.axonframework.upcasting.UpcasterChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcEventStore
implements SnapshotEventStore,
EventStoreManagement,
UpcasterAware,
PartialStreamSupport {
    private static final Logger logger = LoggerFactory.getLogger(JdbcEventStore.class);
    private static final int DEFAULT_BATCH_SIZE = 100;
    private static final int DEFAULT_MAX_SNAPSHOTS_ARCHIVED = 1;
    private final MessageSerializer serializer;
    private final EventEntryStore<?> eventEntryStore;
    private final JdbcCriteriaBuilder criteriaBuilder = new JdbcCriteriaBuilder();
    private int batchSize = 100;
    private UpcasterChain upcasterChain = SimpleUpcasterChain.EMPTY;
    private int maxSnapshotsArchived = 1;
    private PersistenceExceptionResolver persistenceExceptionResolver;

    public JdbcEventStore(EventEntryStore eventEntryStore, Serializer serializer) {
        Assert.notNull(serializer, "serializer may not be null");
        Assert.notNull(eventEntryStore, "eventEntryStore may not be null");
        this.persistenceExceptionResolver = new JdbcSQLErrorCodesResolver();
        this.serializer = new MessageSerializer(serializer);
        this.eventEntryStore = eventEntryStore;
    }

    public JdbcEventStore(EventEntryStore eventEntryStore) {
        this(eventEntryStore, new XStreamSerializer());
    }

    public JdbcEventStore(ConnectionProvider connectionProvider) {
        this(new DefaultEventEntryStore(connectionProvider), new XStreamSerializer());
    }

    public JdbcEventStore(DataSource dataSource) {
        this(new DefaultEventEntryStore(new UnitOfWorkAwareConnectionProviderWrapper(new DataSourceConnectionProvider(dataSource))), new XStreamSerializer());
    }

    @Override
    public void appendEvents(String type, DomainEventStream events) {
        DomainEventMessage event = null;
        try {
            while (events.hasNext()) {
                event = events.next();
                IdentifierValidator.validateIdentifier(event.getAggregateIdentifier().getClass());
                Class<?> dataType = this.eventEntryStore.getDataType();
                SerializedObject<?> serializedPayload = this.serializer.serializePayload(event, dataType);
                SerializedObject<?> serializedMetaData = this.serializer.serializeMetaData(event, dataType);
                this.eventEntryStore.persistEvent(type, event, serializedPayload, serializedMetaData);
            }
        }
        catch (RuntimeException exception) {
            if (this.persistenceExceptionResolver != null && this.persistenceExceptionResolver.isDuplicateKeyViolation(exception)) {
                throw new ConcurrencyException(String.format("Concurrent modification detected for Aggregate identifier [%s], sequence: [%s]", event.getAggregateIdentifier(), event.getSequenceNumber()), exception);
            }
            throw exception;
        }
    }

    @Override
    public DomainEventStream readEvents(String type, Object identifier) {
        long snapshotSequenceNumber = -1L;
        SerializedDomainEventData<?> lastSnapshotEvent = this.eventEntryStore.loadLastSnapshotEvent(type, identifier);
        GenericDomainEventMessage snapshotEvent = null;
        if (lastSnapshotEvent != null) {
            try {
                snapshotEvent = new GenericDomainEventMessage(identifier, lastSnapshotEvent.getSequenceNumber(), this.serializer.deserialize(lastSnapshotEvent.getPayload()), (Map)this.serializer.deserialize(lastSnapshotEvent.getMetaData()));
                snapshotSequenceNumber = snapshotEvent.getSequenceNumber();
            }
            catch (RuntimeException ex) {
                logger.warn("Error while reading snapshot event entry. Reconstructing aggregate on entire event stream. Caused by: {} {}", (Object)ex.getClass().getName(), (Object)ex.getMessage());
            }
            catch (LinkageError error) {
                logger.warn("Error while reading snapshot event entry. Reconstructing aggregate on entire event stream. Caused by: {} {}", (Object)error.getClass().getName(), (Object)error.getMessage());
            }
        }
        Iterator<SerializedDomainEventData<?>> entries = this.eventEntryStore.fetchAggregateStream(type, identifier, snapshotSequenceNumber + 1L, this.batchSize);
        if (snapshotEvent == null && !entries.hasNext()) {
            IOUtils.closeQuietlyIfCloseable(entries);
            throw new EventStreamNotFoundException(type, identifier);
        }
        return new IteratorDomainEventStream(snapshotEvent, entries, identifier, false);
    }

    @Override
    public DomainEventStream readEvents(String type, Object identifier, long firstSequenceNumber) {
        return this.readEvents(type, identifier, firstSequenceNumber, Long.MAX_VALUE);
    }

    @Override
    public DomainEventStream readEvents(String type, Object identifier, long firstSequenceNumber, long lastSequenceNumber) {
        Iterator<SerializedDomainEventData<?>> entries = this.eventEntryStore.fetchAggregateStream(type, identifier, firstSequenceNumber, this.batchSize);
        if (!entries.hasNext()) {
            IOUtils.closeQuietlyIfCloseable(entries);
            throw new EventStreamNotFoundException(type, identifier);
        }
        return new IteratorDomainEventStream(null, entries, identifier, lastSequenceNumber, false);
    }

    @Override
    public void appendSnapshotEvent(String type, DomainEventMessage snapshotEvent) {
        Class<?> dataType = this.eventEntryStore.getDataType();
        SerializedObject<?> serializedPayload = this.serializer.serializePayload(snapshotEvent, dataType);
        SerializedObject<?> serializedMetaData = this.serializer.serializeMetaData(snapshotEvent, dataType);
        try {
            this.eventEntryStore.persistSnapshot(type, snapshotEvent, serializedPayload, serializedMetaData);
        }
        catch (RuntimeException exception) {
            if (this.persistenceExceptionResolver != null && this.persistenceExceptionResolver.isDuplicateKeyViolation(exception)) {
                throw new ConcurrencyException(String.format("A snapshot for aggregate [%s] at sequence: [%s] was already inserted", snapshotEvent.getAggregateIdentifier(), snapshotEvent.getSequenceNumber()), exception);
            }
            throw exception;
        }
        if (this.maxSnapshotsArchived > 0) {
            this.eventEntryStore.pruneSnapshots(type, snapshotEvent, this.maxSnapshotsArchived);
        }
    }

    @Override
    public void visitEvents(EventVisitor visitor) {
        this.doVisitEvents(visitor, null, Collections.<Object>emptyList());
    }

    @Override
    public void visitEvents(Criteria criteria, EventVisitor visitor) {
        StringBuilder sb = new StringBuilder();
        ParameterRegistry parameters = new ParameterRegistry();
        ((JdbcCriteria)criteria).parse("", sb, parameters);
        this.doVisitEvents(visitor, sb.toString(), parameters.getParameters());
    }

    @Override
    public CriteriaBuilder newCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doVisitEvents(EventVisitor visitor, String whereClause, List<Object> parameters) {
        Iterator<SerializedDomainEventData<?>> batch = this.eventEntryStore.fetchFiltered(whereClause, parameters, this.batchSize);
        IteratorDomainEventStream eventStream = new IteratorDomainEventStream(null, batch, null, true);
        try {
            while (eventStream.hasNext()) {
                visitor.doWithEvent(eventStream.next());
            }
        }
        finally {
            IOUtils.closeQuietlyIfCloseable(eventStream);
        }
    }

    public void setPersistenceExceptionResolver(PersistenceExceptionResolver persistenceExceptionResolver) {
        this.persistenceExceptionResolver = persistenceExceptionResolver;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public void setUpcasterChain(UpcasterChain upcasterChain) {
        this.upcasterChain = upcasterChain;
    }

    public void setMaxSnapshotsArchived(int maxSnapshotsArchived) {
        this.maxSnapshotsArchived = maxSnapshotsArchived;
    }

    private final class IteratorDomainEventStream
    implements DomainEventStream,
    Closeable {
        private Iterator<DomainEventMessage> currentBatch;
        private DomainEventMessage next;
        private final Iterator<? extends SerializedDomainEventData> iterator;
        private final Object aggregateIdentifier;
        private final long lastSequenceNumber;
        private final boolean skipUnknownTypes;

        public IteratorDomainEventStream(DomainEventMessage snapshotEvent, Iterator<? extends SerializedDomainEventData> iterator, Object aggregateIdentifier, boolean skipUnknownTypes) {
            this(snapshotEvent, iterator, aggregateIdentifier, Long.MAX_VALUE, skipUnknownTypes);
        }

        public IteratorDomainEventStream(DomainEventMessage snapshotEvent, Iterator<? extends SerializedDomainEventData> iterator, Object aggregateIdentifier, long lastSequenceNumber, boolean skipUnknownTypes) {
            this.aggregateIdentifier = aggregateIdentifier;
            this.lastSequenceNumber = lastSequenceNumber;
            this.skipUnknownTypes = skipUnknownTypes;
            this.currentBatch = snapshotEvent != null ? Collections.singletonList(snapshotEvent).iterator() : Collections.emptyList().iterator();
            this.iterator = iterator;
            this.initializeNextItem();
        }

        @Override
        public boolean hasNext() {
            return this.next != null && this.next.getSequenceNumber() <= this.lastSequenceNumber;
        }

        @Override
        public DomainEventMessage next() {
            DomainEventMessage current = this.next;
            this.initializeNextItem();
            return current;
        }

        private void initializeNextItem() {
            while (!this.currentBatch.hasNext() && this.iterator.hasNext()) {
                SerializedDomainEventData entry = this.iterator.next();
                this.currentBatch = UpcastUtils.upcastAndDeserialize(entry, this.aggregateIdentifier, JdbcEventStore.this.serializer, JdbcEventStore.this.upcasterChain, this.skipUnknownTypes).iterator();
            }
            DomainEventMessage domainEventMessage = this.next = this.currentBatch.hasNext() ? this.currentBatch.next() : null;
            if (this.next != null && this.next.getSequenceNumber() > this.lastSequenceNumber) {
                this.next = null;
            }
        }

        @Override
        public DomainEventMessage peek() {
            return this.next;
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeIfCloseable(this.iterator);
        }
    }
}

