/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.jdbc;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.axonframework.common.io.IOUtils;
import org.axonframework.common.jdbc.ConnectionProvider;
import org.axonframework.common.jdbc.DataSourceConnectionProvider;
import org.axonframework.common.jdbc.JdbcUtils;
import org.axonframework.common.jdbc.UnitOfWorkAwareConnectionProviderWrapper;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.eventstore.EventStoreException;
import org.axonframework.eventstore.jdbc.EventEntryStore;
import org.axonframework.eventstore.jdbc.EventSqlSchema;
import org.axonframework.eventstore.jdbc.GenericEventSqlSchema;
import org.axonframework.serializer.SerializedDomainEventData;
import org.axonframework.serializer.SerializedObject;

public class DefaultEventEntryStore<T>
implements EventEntryStore<T> {
    private final ConnectionProvider connectionProvider;
    private final EventSqlSchema<T> sqlSchema;

    public DefaultEventEntryStore(DataSource dataSource, EventSqlSchema<T> sqlSchema) {
        this(new UnitOfWorkAwareConnectionProviderWrapper(new DataSourceConnectionProvider(dataSource)), sqlSchema);
    }

    public DefaultEventEntryStore(ConnectionProvider connectionProvider, EventSqlSchema<T> sqlSchema) {
        this.connectionProvider = connectionProvider;
        this.sqlSchema = sqlSchema;
    }

    public DefaultEventEntryStore(ConnectionProvider connectionProvider) {
        this(connectionProvider, new GenericEventSqlSchema());
    }

    @Override
    public SerializedDomainEventData<T> loadLastSnapshotEvent(String aggregateType, Object identifier) {
        SerializedDomainEventData<T> serializedDomainEventData;
        Connection connection;
        PreparedStatement preparedStatement;
        ResultSet result;
        block5: {
            result = null;
            preparedStatement = null;
            connection = null;
            connection = this.connectionProvider.getConnection();
            preparedStatement = this.sqlSchema.sql_loadLastSnapshot(connection, identifier, aggregateType);
            result = preparedStatement.executeQuery();
            if (!result.next()) break block5;
            SerializedDomainEventData<T> serializedDomainEventData2 = this.sqlSchema.createSerializedDomainEventData(result);
            JdbcUtils.closeQuietly(result);
            JdbcUtils.closeQuietly(preparedStatement);
            JdbcUtils.closeQuietly(connection);
            return serializedDomainEventData2;
        }
        try {
            serializedDomainEventData = null;
        }
        catch (SQLException e) {
            try {
                throw new EventStoreException("Exception while attempting to load last snapshot event of " + aggregateType + "/" + identifier, e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(result);
                JdbcUtils.closeQuietly(preparedStatement);
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(result);
        JdbcUtils.closeQuietly(preparedStatement);
        JdbcUtils.closeQuietly(connection);
        return serializedDomainEventData;
    }

    @Override
    public Iterator<SerializedDomainEventData<T>> fetchFiltered(String whereClause, List<Object> parameters, int batchSize) {
        try {
            Connection connection = this.connectionProvider.getConnection();
            return new ConnectionResourceManagingIterator(new FilteredBatchingIterator<T>(whereClause, parameters, batchSize, this.sqlSchema, connection), connection);
        }
        catch (SQLException e) {
            throw new EventStoreException("Exception while attempting to read from the Event Store database", e);
        }
    }

    @Override
    public void persistSnapshot(String aggregateType, DomainEventMessage snapshotEvent, SerializedObject<T> serializedPayload, SerializedObject<T> serializedMetaData) {
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = this.connectionProvider.getConnection();
            preparedStatement = this.sqlSchema.sql_insertSnapshotEventEntry(connection, snapshotEvent.getIdentifier(), snapshotEvent.getAggregateIdentifier().toString(), snapshotEvent.getSequenceNumber(), snapshotEvent.getTimestamp(), serializedPayload.getType().getName(), serializedPayload.getType().getRevision(), serializedPayload.getData(), serializedMetaData.getData(), aggregateType);
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new EventStoreException("Exception while attempting to persist a snapshot", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(preparedStatement);
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(preparedStatement);
        JdbcUtils.closeQuietly(connection);
    }

    @Override
    public void persistEvent(String aggregateType, DomainEventMessage event, SerializedObject<T> serializedPayload, SerializedObject<T> serializedMetaData) {
        PreparedStatement preparedStatement = null;
        Connection connection = null;
        try {
            connection = this.connectionProvider.getConnection();
            preparedStatement = this.sqlSchema.sql_insertDomainEventEntry(connection, event.getIdentifier(), event.getAggregateIdentifier().toString(), event.getSequenceNumber(), event.getTimestamp(), serializedPayload.getType().getName(), serializedPayload.getType().getRevision(), serializedPayload.getData(), serializedMetaData.getData(), aggregateType);
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new EventStoreException("Exception occurred while attempting to persist an event", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(preparedStatement);
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(preparedStatement);
        JdbcUtils.closeQuietly(connection);
    }

    @Override
    public void pruneSnapshots(String type, DomainEventMessage mostRecentSnapshotEvent, int maxSnapshotsArchived) {
        Iterator<Long> redundantSnapshots = this.findRedundantSnapshots(type, mostRecentSnapshotEvent, maxSnapshotsArchived);
        if (redundantSnapshots.hasNext()) {
            long sequenceOfFirstSnapshotToPrune = redundantSnapshots.next();
            Connection connection = null;
            try {
                connection = this.connectionProvider.getConnection();
                this.executeUpdate(this.sqlSchema.sql_pruneSnapshots(connection, type, mostRecentSnapshotEvent.getAggregateIdentifier(), sequenceOfFirstSnapshotToPrune), "prune snapshots");
            }
            catch (SQLException e) {
                throw new EventStoreException("An exception occurred while attempting to prune snapshots", e);
            }
            finally {
                JdbcUtils.closeQuietly(connection);
            }
        }
    }

    @Override
    public Class<T> getDataType() {
        return this.sqlSchema.getDataType();
    }

    private Iterator<Long> findRedundantSnapshots(String type, DomainEventMessage snapshotEvent, int maxSnapshotsArchived) {
        Iterator<Long> iterator;
        ResultSet resultSet = null;
        PreparedStatement statement = null;
        Connection connection = null;
        try {
            connection = this.connectionProvider.getConnection();
            statement = this.sqlSchema.sql_findSnapshotSequenceNumbers(connection, type, snapshotEvent.getAggregateIdentifier());
            resultSet = statement.executeQuery();
            while (maxSnapshotsArchived-- > 0 && resultSet.next()) {
            }
            ArrayList<Long> result = new ArrayList<Long>();
            while (resultSet.next()) {
                result.add(resultSet.getLong(1));
            }
            resultSet.close();
            iterator = result.iterator();
        }
        catch (SQLException e) {
            try {
                throw new EventStoreException("Exception ", e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(resultSet);
                JdbcUtils.closeQuietly(statement);
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(resultSet);
        JdbcUtils.closeQuietly(statement);
        JdbcUtils.closeQuietly(connection);
        return iterator;
    }

    @Override
    public Iterator<SerializedDomainEventData<T>> fetchAggregateStream(String aggregateType, Object identifier, long firstSequenceNumber, int fetchSize) {
        Connection connection = null;
        PreparedStatement statement = null;
        try {
            connection = this.connectionProvider.getConnection();
            statement = this.sqlSchema.sql_fetchFromSequenceNumber(connection, aggregateType, identifier, firstSequenceNumber);
            statement.setFetchSize(fetchSize);
            return new ConnectionResourceManagingIterator(new PreparedStatementIterator<T>(statement, this.sqlSchema), connection);
        }
        catch (SQLException e) {
            JdbcUtils.closeQuietly(connection);
            JdbcUtils.closeQuietly(statement);
            throw new EventStoreException("Exception while attempting to read from an Aggregate Stream", e);
        }
    }

    private int executeUpdate(PreparedStatement preparedStatement, String description) {
        try {
            int n = preparedStatement.executeUpdate();
            return n;
        }
        catch (SQLException e) {
            throw new EventStoreException("Exception occurred while attempting to " + description, e);
        }
        finally {
            JdbcUtils.closeQuietly(preparedStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createSchema() throws SQLException {
        Connection connection = null;
        try {
            connection = this.connectionProvider.getConnection();
            this.executeUpdate(this.sqlSchema.sql_createDomainEventEntryTable(connection), "create domain event entry table");
            this.executeUpdate(this.sqlSchema.sql_createSnapshotEventEntryTable(connection), "create snapshot entry table");
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    private static class ResultSetIterator<T>
    implements Iterator<SerializedDomainEventData<T>>,
    Closeable {
        private final ResultSet rs;
        private final EventSqlSchema<T> sqlSchema;
        private boolean hasCalledNext = false;
        private boolean hasNext;
        private int counter = 0;

        public ResultSetIterator(ResultSet resultSet, EventSqlSchema<T> sqlSchema) {
            this.rs = resultSet;
            this.sqlSchema = sqlSchema;
        }

        @Override
        public boolean hasNext() {
            try {
                this.establishNext();
                return this.hasNext;
            }
            catch (SQLException e) {
                throw new EventStoreException("Exception occurred while attempting to fetch data from ResultSet", e);
            }
        }

        private void establishNext() throws SQLException {
            if (!this.hasCalledNext) {
                this.hasNext = this.rs.next();
                this.hasCalledNext = true;
            }
        }

        @Override
        public SerializedDomainEventData<T> next() {
            try {
                this.establishNext();
                if (this.hasNext) {
                    ++this.counter;
                }
                SerializedDomainEventData<T> serializedDomainEventData = this.sqlSchema.createSerializedDomainEventData(this.rs);
                return serializedDomainEventData;
            }
            catch (SQLException e) {
                throw new EventStoreException("Exception occurred while attempting to read next event from ResultSet", e);
            }
            finally {
                this.hasCalledNext = false;
            }
        }

        public int readCount() {
            return this.counter;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Iterator is read-only");
        }

        @Override
        public void close() throws IOException {
            JdbcUtils.closeQuietly(this.rs);
        }
    }

    private static class PreparedStatementIterator<T>
    implements Iterator<SerializedDomainEventData<T>>,
    Closeable {
        private final PreparedStatement statement;
        private final ResultSetIterator<T> rsIterator;

        public PreparedStatementIterator(PreparedStatement statement, EventSqlSchema<T> sqlSchema) {
            this.statement = statement;
            try {
                ResultSet resultSet = statement.executeQuery();
                this.rsIterator = new ResultSetIterator<T>(resultSet, sqlSchema);
            }
            catch (SQLException e) {
                throw new EventStoreException("Exception occurred while attempting to execute query on statement", e);
            }
        }

        public int readCount() {
            return this.rsIterator.readCount();
        }

        @Override
        public boolean hasNext() {
            return this.rsIterator.hasNext();
        }

        @Override
        public SerializedDomainEventData<T> next() {
            return this.rsIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Iterator is read-only");
        }

        @Override
        public void close() throws IOException {
            this.rsIterator.close();
            JdbcUtils.closeQuietly(this.statement);
        }
    }

    private static class FilteredBatchingIterator<T>
    implements Iterator<SerializedDomainEventData<T>>,
    Closeable {
        private final Connection connection;
        private PreparedStatementIterator<T> currentBatch;
        private SerializedDomainEventData<T> next;
        private SerializedDomainEventData<T> lastItem;
        private final String whereClause;
        private final List<Object> parameters;
        private final int batchSize;
        private final EventSqlSchema<T> sqlSchema;

        public FilteredBatchingIterator(String whereClause, List<Object> parameters, int batchSize, EventSqlSchema<T> sqlSchema, Connection connection) {
            this.whereClause = whereClause;
            this.parameters = parameters;
            this.batchSize = batchSize;
            this.connection = connection;
            this.sqlSchema = sqlSchema;
            this.currentBatch = this.fetchBatch();
            if (this.currentBatch.hasNext()) {
                this.next = this.currentBatch.next();
            }
        }

        private PreparedStatementIterator<T> fetchBatch() {
            LinkedList<Object> params = new LinkedList<Object>(this.parameters);
            String batchWhereClause = this.buildWhereClause(params);
            try {
                PreparedStatement sql = this.sqlSchema.sql_getFetchAll(this.connection, batchWhereClause, params.toArray());
                sql.setMaxRows(this.batchSize);
                return new PreparedStatementIterator<T>(sql, this.sqlSchema);
            }
            catch (SQLException e) {
                throw new EventStoreException("Exception occurred while attempting to execute prepared statement", e);
            }
        }

        private String buildWhereClause(List<Object> params) {
            if (this.lastItem == null && this.whereClause == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            if (this.lastItem != null) {
                sb.append("(").append("(e.timeStamp > ?)").append(" OR ").append("(e.timeStamp = ? AND e.sequenceNumber > ?)").append(" OR ").append("(e.timeStamp = ? AND e.sequenceNumber = ? AND e.aggregateIdentifier > ?)").append(")");
                Object dateTimeSql = this.sqlSchema.sql_dateTime(this.lastItem.getTimestamp());
                params.add(0, dateTimeSql);
                params.add(1, dateTimeSql);
                params.add(2, this.lastItem.getSequenceNumber());
                params.add(3, dateTimeSql);
                params.add(4, this.lastItem.getSequenceNumber());
                params.add(5, this.lastItem.getAggregateIdentifier());
            }
            if (this.whereClause != null && this.whereClause.length() > 0) {
                if (this.lastItem != null) {
                    sb.append(" AND (");
                }
                sb.append(this.whereClause);
                if (this.lastItem != null) {
                    sb.append(")");
                }
            }
            if (sb.length() > 0) {
                sb.insert(0, "WHERE ");
            }
            return sb.toString();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public SerializedDomainEventData<T> next() {
            SerializedDomainEventData<T> current = this.next;
            this.lastItem = this.next;
            if (this.next != null && !this.currentBatch.hasNext() && this.currentBatch.readCount() >= this.batchSize) {
                IOUtils.closeQuietly(this.currentBatch);
                this.currentBatch = this.fetchBatch();
            }
            this.next = this.currentBatch.hasNext() ? this.currentBatch.next() : null;
            return current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Iterator is read-only");
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeQuietly(this.currentBatch);
        }
    }

    private static class ConnectionResourceManagingIterator<T>
    implements Iterator<SerializedDomainEventData<T>>,
    Closeable {
        private final Iterator<SerializedDomainEventData<T>> inner;
        private final Connection connection;

        public ConnectionResourceManagingIterator(Iterator<SerializedDomainEventData<T>> inner, Connection connection) {
            this.inner = inner;
            this.connection = connection;
        }

        @Override
        public boolean hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public SerializedDomainEventData<T> next() {
            return this.inner.next();
        }

        @Override
        public void remove() {
            this.inner.remove();
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeQuietlyIfCloseable(this.inner);
            JdbcUtils.closeQuietly(this.connection);
        }
    }
}

