/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventstore.fs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import org.axonframework.common.Assert;
import org.axonframework.common.io.IOUtils;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.eventstore.EventStore;
import org.axonframework.eventstore.EventStoreException;
import org.axonframework.eventstore.EventStreamNotFoundException;
import org.axonframework.eventstore.SnapshotEventStore;
import org.axonframework.eventstore.fs.EventFileResolver;
import org.axonframework.eventstore.fs.FileSystemBufferedReaderDomainEventStream;
import org.axonframework.eventstore.fs.FileSystemEventMessageWriter;
import org.axonframework.eventstore.fs.FileSystemSnapshotEventReader;
import org.axonframework.eventstore.fs.FileSystemSnapshotEventWriter;
import org.axonframework.repository.ConflictingModificationException;
import org.axonframework.serializer.Serializer;
import org.axonframework.serializer.xml.XStreamSerializer;
import org.axonframework.upcasting.SimpleUpcasterChain;
import org.axonframework.upcasting.UpcasterAware;
import org.axonframework.upcasting.UpcasterChain;

public class FileSystemEventStore
implements EventStore,
SnapshotEventStore,
UpcasterAware {
    private final Serializer eventSerializer;
    private final EventFileResolver eventFileResolver;
    private UpcasterChain upcasterChain = SimpleUpcasterChain.EMPTY;

    public FileSystemEventStore(EventFileResolver eventFileResolver) {
        this(new XStreamSerializer(), eventFileResolver);
    }

    public FileSystemEventStore(Serializer serializer, EventFileResolver eventFileResolver) {
        Assert.notNull(serializer, "serializer may not be null");
        Assert.notNull(eventFileResolver, "eventFileResolver may not be null");
        this.eventSerializer = serializer;
        this.eventFileResolver = eventFileResolver;
    }

    @Override
    public void appendEvents(String type, DomainEventStream eventsToStore) {
        if (!eventsToStore.hasNext()) {
            return;
        }
        OutputStream out = null;
        try {
            DomainEventMessage next = eventsToStore.next();
            if (next.getSequenceNumber() == 0L && this.eventFileResolver.eventFileExists(type, next.getAggregateIdentifier())) {
                throw new ConflictingModificationException("Could not create event stream for aggregate, such stream already exists, type=" + type + ", id=" + next.getAggregateIdentifier());
            }
            out = this.eventFileResolver.openEventFileForWriting(type, next.getAggregateIdentifier());
            FileSystemEventMessageWriter eventMessageWriter = new FileSystemEventMessageWriter(new DataOutputStream(out), this.eventSerializer);
            do {
                eventMessageWriter.writeEventMessage(next);
            } while ((next = eventsToStore.hasNext() ? eventsToStore.next() : null) != null);
        }
        catch (IOException e) {
            try {
                throw new EventStoreException("Unable to store given entity due to an IOException", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(out);
    }

    @Override
    public DomainEventStream readEvents(String type, Object aggregateIdentifier) {
        try {
            DomainEventMessage snapshotEvent;
            if (!this.eventFileResolver.eventFileExists(type, aggregateIdentifier)) {
                throw new EventStreamNotFoundException(type, aggregateIdentifier);
            }
            InputStream eventFileInputStream = this.eventFileResolver.openEventFileForReading(type, aggregateIdentifier);
            try {
                snapshotEvent = this.readSnapshotEvent(type, aggregateIdentifier, eventFileInputStream);
                snapshotEvent.getPayload();
            }
            catch (Exception e) {
                snapshotEvent = null;
                IOUtils.closeQuietly(eventFileInputStream);
                eventFileInputStream = this.eventFileResolver.openEventFileForReading(type, aggregateIdentifier);
            }
            InputStream is = eventFileInputStream;
            if (snapshotEvent != null) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                FileSystemEventMessageWriter snapshotEventMessageWriter = new FileSystemEventMessageWriter(new DataOutputStream(baos), this.eventSerializer);
                snapshotEventMessageWriter.writeEventMessage(snapshotEvent);
                is = new SequenceInputStream(new ByteArrayInputStream(baos.toByteArray()), eventFileInputStream);
            }
            return new FileSystemBufferedReaderDomainEventStream(is, this.eventSerializer, this.upcasterChain);
        }
        catch (IOException e) {
            throw new EventStoreException(String.format("An error occurred while trying to open the event file for aggregate type [%s] with identifier [%s]", type, aggregateIdentifier), e);
        }
    }

    @Override
    public void appendSnapshotEvent(String type, DomainEventMessage snapshotEvent) throws EventStoreException {
        InputStream eventFile = null;
        try {
            eventFile = this.eventFileResolver.openEventFileForReading(type, snapshotEvent.getAggregateIdentifier());
            OutputStream snapshotEventFile = this.eventFileResolver.openSnapshotFileForWriting(type, snapshotEvent.getAggregateIdentifier());
            FileSystemSnapshotEventWriter snapshotEventWriter = new FileSystemSnapshotEventWriter(eventFile, snapshotEventFile, this.eventSerializer);
            snapshotEventWriter.writeSnapshotEvent(snapshotEvent);
        }
        catch (IOException e) {
            try {
                throw new EventStoreException("Error writing a snapshot event due to an IO exception", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(eventFile);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(eventFile);
    }

    private DomainEventMessage readSnapshotEvent(String type, Object identifier, InputStream eventFileInputStream) throws IOException {
        DomainEventMessage snapshotEvent = null;
        if (this.eventFileResolver.snapshotFileExists(type, identifier)) {
            InputStream snapshotEventFile = this.eventFileResolver.openSnapshotFileForReading(type, identifier);
            FileSystemSnapshotEventReader fileSystemSnapshotEventReader = new FileSystemSnapshotEventReader(eventFileInputStream, snapshotEventFile, this.eventSerializer);
            snapshotEvent = fileSystemSnapshotEventReader.readSnapshotEvent(type, identifier);
        }
        return snapshotEvent;
    }

    @Override
    public void setUpcasterChain(UpcasterChain upcasterChain) {
        this.upcasterChain = upcasterChain;
    }
}

