/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.eventsourcing.AggregateSnapshotter;
import org.axonframework.eventsourcing.EventSourcingRepository;
import org.axonframework.unitofwork.SpringTransactionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public class SpringAggregateSnapshotter
extends AggregateSnapshotter
implements InitializingBean,
ApplicationContextAware {
    private PlatformTransactionManager transactionManager;
    private boolean autoDetectAggregateFactories = true;
    private ApplicationContext applicationContext;
    private TransactionDefinition transactionDefinition = new DefaultTransactionDefinition();

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionDefinition(TransactionDefinition transactionDefinition) {
        this.transactionDefinition = transactionDefinition;
    }

    public void afterPropertiesSet() throws Exception {
        Map candidates;
        if (this.autoDetectAggregateFactories) {
            HashSet<Object> factoriesFound = new HashSet<Object>();
            factoriesFound.addAll(this.applicationContext.getBeansOfType(AggregateFactory.class).values());
            Collection eventSourcingRepositories = this.applicationContext.getBeansOfType(EventSourcingRepository.class).values();
            for (EventSourcingRepository repo : eventSourcingRepositories) {
                factoriesFound.add(repo.getAggregateFactory());
            }
            this.setAggregateFactories(new ArrayList(factoriesFound));
        }
        if (this.transactionManager == null && (candidates = this.applicationContext.getBeansOfType(PlatformTransactionManager.class)).size() == 1) {
            this.transactionManager = (PlatformTransactionManager)candidates.values().iterator().next();
        }
        if (this.transactionManager != null) {
            this.setTxManager(new SpringTransactionManager(this.transactionManager, this.transactionDefinition));
        }
    }

    @Override
    public void setAggregateFactories(List<AggregateFactory<?>> aggregateFactories) {
        this.autoDetectAggregateFactories = false;
        super.setAggregateFactories(aggregateFactories);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

