/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.axonframework.cache.Cache;
import org.axonframework.common.io.IOUtils;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.eventsourcing.EventSourcedAggregateRoot;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventsourcing.SnapshotterTrigger;
import org.axonframework.unitofwork.CurrentUnitOfWork;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkListenerAdapter;

public class EventCountSnapshotterTrigger
implements SnapshotterTrigger {
    private static final int DEFAULT_TRIGGER_VALUE = 50;
    private Snapshotter snapshotter;
    private final ConcurrentMap<Object, AtomicInteger> counters = new ConcurrentHashMap<Object, AtomicInteger>();
    private volatile boolean clearCountersAfterAppend = true;
    private int trigger = 50;

    @Override
    public DomainEventStream decorateForRead(String aggregateType, Object aggregateIdentifier, DomainEventStream eventStream) {
        AtomicInteger counter = new AtomicInteger(0);
        this.counters.put(aggregateIdentifier, counter);
        return new CountingEventStream(eventStream, counter);
    }

    @Override
    public DomainEventStream decorateForAppend(String aggregateType, EventSourcedAggregateRoot aggregate, DomainEventStream eventStream) {
        Object aggregateIdentifier = aggregate.getIdentifier();
        this.counters.putIfAbsent(aggregateIdentifier, new AtomicInteger(0));
        AtomicInteger counter = (AtomicInteger)this.counters.get(aggregateIdentifier);
        return new TriggeringEventStream(aggregateType, aggregateIdentifier, eventStream, counter);
    }

    private void triggerSnapshotIfRequired(String type, Object aggregateIdentifier, AtomicInteger eventCount) {
        if (eventCount.get() > this.trigger) {
            this.snapshotter.scheduleSnapshot(type, aggregateIdentifier);
            eventCount.set(1);
        }
    }

    public void setSnapshotter(Snapshotter snapshotter) {
        this.snapshotter = snapshotter;
    }

    public void setTrigger(int trigger) {
        this.trigger = trigger;
    }

    public void setClearCountersAfterAppend(boolean clearCountersAfterAppend) {
        this.clearCountersAfterAppend = clearCountersAfterAppend;
    }

    public void setAggregateCache(Cache cache) {
        this.clearCountersAfterAppend = false;
        cache.registerCacheEntryListener(new CacheListener());
    }

    public void setAggregateCaches(List<Cache> caches) {
        for (Cache cache : caches) {
            this.setAggregateCache(cache);
        }
    }

    private class SnapshotTriggeringListener
    extends UnitOfWorkListenerAdapter {
        private final String aggregateType;
        private final Object aggregateIdentifier;
        private final AtomicInteger counter;

        public SnapshotTriggeringListener(String aggregateType, Object aggregateIdentifier, AtomicInteger counter) {
            this.aggregateType = aggregateType;
            this.aggregateIdentifier = aggregateIdentifier;
            this.counter = counter;
        }

        @Override
        public void onCleanup(UnitOfWork unitOfWork) {
            EventCountSnapshotterTrigger.this.triggerSnapshotIfRequired(this.aggregateType, this.aggregateIdentifier, this.counter);
        }
    }

    private final class CacheListener
    extends Cache.EntryListenerAdapter {
        private CacheListener() {
        }

        @Override
        public void onEntryExpired(Object key) {
            EventCountSnapshotterTrigger.this.counters.remove(key);
        }

        @Override
        public void onEntryRemoved(Object key) {
            EventCountSnapshotterTrigger.this.counters.remove(key);
        }
    }

    private final class TriggeringEventStream
    extends CountingEventStream {
        private final String aggregateType;
        private final Object aggregateIdentifier;

        private TriggeringEventStream(String aggregateType, Object aggregateIdentifier, DomainEventStream delegate, AtomicInteger counter) {
            super(delegate, counter);
            this.aggregateType = aggregateType;
            this.aggregateIdentifier = aggregateIdentifier;
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = super.hasNext();
            if (!hasNext) {
                CurrentUnitOfWork.get().registerListener(new SnapshotTriggeringListener(this.aggregateType, this.aggregateIdentifier, this.getCounter()));
                if (EventCountSnapshotterTrigger.this.clearCountersAfterAppend) {
                    EventCountSnapshotterTrigger.this.counters.remove(this.aggregateIdentifier, this.getCounter());
                }
            }
            return hasNext;
        }
    }

    private class CountingEventStream
    implements DomainEventStream,
    Closeable {
        private final DomainEventStream delegate;
        private final AtomicInteger counter;

        public CountingEventStream(DomainEventStream delegate, AtomicInteger counter) {
            this.delegate = delegate;
            this.counter = counter;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public DomainEventMessage next() {
            DomainEventMessage next = this.delegate.next();
            this.counter.incrementAndGet();
            return next;
        }

        @Override
        public DomainEventMessage peek() {
            return this.delegate.peek();
        }

        protected AtomicInteger getCounter() {
            return this.counter;
        }

        @Override
        public void close() throws IOException {
            IOUtils.closeIfCloseable(this.delegate);
        }
    }
}

