/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.Collection;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.eventsourcing.EventSourcedAggregateRoot;
import org.axonframework.eventsourcing.EventStreamDecorator;

public class CompositeEventStreamDecorator
implements EventStreamDecorator {
    private final EventStreamDecorator[] eventStreamDecorators;

    public CompositeEventStreamDecorator(Collection<EventStreamDecorator> eventStreamDecorators) {
        this.eventStreamDecorators = eventStreamDecorators.toArray(new EventStreamDecorator[eventStreamDecorators.size()]);
    }

    @Override
    public DomainEventStream decorateForRead(String aggregateType, Object aggregateIdentifier, DomainEventStream eventStream) {
        DomainEventStream events = eventStream;
        for (EventStreamDecorator decorator : this.eventStreamDecorators) {
            events = decorator.decorateForRead(aggregateType, aggregateIdentifier, events);
        }
        return events;
    }

    @Override
    public DomainEventStream decorateForAppend(String aggregateType, EventSourcedAggregateRoot aggregate, DomainEventStream eventStream) {
        DomainEventStream events = eventStream;
        for (int i = this.eventStreamDecorators.length - 1; i >= 0; --i) {
            events = this.eventStreamDecorators[i].decorateForAppend(aggregateType, aggregate, events);
        }
        return events;
    }
}

