/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.domain.GenericDomainEventMessage;
import org.axonframework.eventsourcing.AbstractSnapshotter;
import org.axonframework.eventsourcing.AggregateFactory;

public class AggregateSnapshotter
extends AbstractSnapshotter {
    private final Map<String, AggregateFactory<?>> aggregateFactories = new ConcurrentHashMap();

    @Override
    protected DomainEventMessage createSnapshot(String typeIdentifier, Object aggregateIdentifier, DomainEventStream eventStream) {
        DomainEventMessage firstEvent = eventStream.peek();
        AggregateFactory<?> aggregateFactory = this.aggregateFactories.get(typeIdentifier);
        Object aggregate = aggregateFactory.createAggregate(aggregateIdentifier, firstEvent);
        aggregate.initializeState(eventStream);
        return new GenericDomainEventMessage(aggregate.getIdentifier(), aggregate.getVersion(), aggregate);
    }

    public void setAggregateFactories(List<AggregateFactory<?>> aggregateFactories) {
        for (AggregateFactory<?> factory : aggregateFactories) {
            this.aggregateFactories.put(factory.getTypeIdentifier(), factory);
        }
    }
}

