/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.concurrent.Executor;
import org.axonframework.common.DirectExecutor;
import org.axonframework.common.io.IOUtils;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.eventsourcing.Snapshotter;
import org.axonframework.eventstore.SnapshotEventStore;
import org.axonframework.repository.ConcurrencyException;
import org.axonframework.unitofwork.NoTransactionManager;
import org.axonframework.unitofwork.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSnapshotter
implements Snapshotter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSnapshotter.class);
    private SnapshotEventStore eventStore;
    private Executor executor = DirectExecutor.INSTANCE;
    private TransactionManager transactionManager = new NoTransactionManager();

    @Override
    public void scheduleSnapshot(String typeIdentifier, Object aggregateIdentifier) {
        this.executor.execute(new SilentTask(new TransactionalRunnableWrapper(this.transactionManager, this.createSnapshotterTask(typeIdentifier, aggregateIdentifier))));
    }

    protected Runnable createSnapshotterTask(String typeIdentifier, Object aggregateIdentifier) {
        return new CreateSnapshotTask(typeIdentifier, aggregateIdentifier);
    }

    protected abstract DomainEventMessage createSnapshot(String var1, Object var2, DomainEventStream var3);

    public void setTxManager(TransactionManager<?> transactionManager) {
        this.transactionManager = transactionManager;
    }

    protected SnapshotEventStore getEventStore() {
        return this.eventStore;
    }

    public void setEventStore(SnapshotEventStore eventStore) {
        this.eventStore = eventStore;
    }

    protected Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    private final class CreateSnapshotTask
    implements Runnable {
        private final String typeIdentifier;
        private final Object aggregateIdentifier;

        private CreateSnapshotTask(String typeIdentifier, Object aggregateIdentifier) {
            this.typeIdentifier = typeIdentifier;
            this.aggregateIdentifier = aggregateIdentifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DomainEventStream eventStream = AbstractSnapshotter.this.eventStore.readEvents(this.typeIdentifier, this.aggregateIdentifier);
            try {
                long firstEventSequenceNumber = eventStream.peek().getSequenceNumber();
                DomainEventMessage snapshotEvent = AbstractSnapshotter.this.createSnapshot(this.typeIdentifier, this.aggregateIdentifier, eventStream);
                if (snapshotEvent != null && snapshotEvent.getSequenceNumber() > firstEventSequenceNumber) {
                    AbstractSnapshotter.this.eventStore.appendSnapshotEvent(this.typeIdentifier, snapshotEvent);
                }
            }
            finally {
                IOUtils.closeQuietlyIfCloseable(eventStream);
            }
        }
    }

    private static class SilentTask
    implements Runnable {
        private final Runnable snapshotterTask;

        public SilentTask(Runnable snapshotterTask) {
            this.snapshotterTask = snapshotterTask;
        }

        @Override
        public void run() {
            try {
                this.snapshotterTask.run();
            }
            catch (ConcurrencyException e) {
                logger.info("An up-to-date snapshot entry already exists, ignoring this attempts.");
            }
            catch (RuntimeException e) {
                if (logger.isDebugEnabled()) {
                    logger.warn("An attempt to create and store a snapshot resulted in an exception:", (Throwable)e);
                }
                logger.warn("An attempt to create and store a snapshot resulted in an exception. Exception summary: {}", (Object)e.getMessage());
            }
        }
    }

    private static class TransactionalRunnableWrapper
    implements Runnable {
        private final Runnable command;
        private final TransactionManager transactionManager;

        public TransactionalRunnableWrapper(TransactionManager transactionManager, Runnable command) {
            this.command = command;
            this.transactionManager = transactionManager;
        }

        @Override
        public void run() {
            Object transaction = this.transactionManager.startTransaction();
            try {
                this.command.run();
                this.transactionManager.commitTransaction(transaction);
            }
            catch (RuntimeException e) {
                this.transactionManager.rollbackTransaction(transaction);
                throw e;
            }
        }
    }
}

