/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.Collection;
import org.axonframework.common.Assert;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.MetaData;
import org.axonframework.eventsourcing.AbstractEventSourcedAggregateRoot;
import org.axonframework.eventsourcing.EventSourcedEntity;

public abstract class AbstractEventSourcedEntity
implements EventSourcedEntity {
    private volatile AbstractEventSourcedAggregateRoot aggregateRoot;

    @Override
    public void registerAggregateRoot(AbstractEventSourcedAggregateRoot aggregateRootToRegister) {
        if (this.aggregateRoot != null && this.aggregateRoot != aggregateRootToRegister) {
            throw new IllegalStateException("Cannot register new aggregate. This entity is already part of another aggregate");
        }
        this.aggregateRoot = aggregateRootToRegister;
    }

    @Override
    public void handleRecursively(DomainEventMessage event) {
        this.handle(event);
        Collection<? extends EventSourcedEntity> childEntities = this.getChildEntities();
        if (childEntities != null) {
            for (EventSourcedEntity eventSourcedEntity : childEntities) {
                if (eventSourcedEntity == null) continue;
                eventSourcedEntity.registerAggregateRoot(this.aggregateRoot);
                eventSourcedEntity.handleRecursively(event);
            }
        }
    }

    protected abstract Collection<? extends EventSourcedEntity> getChildEntities();

    protected abstract void handle(DomainEventMessage var1);

    protected void apply(Object event) {
        this.apply(event, MetaData.emptyInstance());
    }

    protected void apply(Object event, MetaData metaData) {
        Assert.notNull(this.aggregateRoot, "The aggregate root is unknown. Is this entity properly registered as the child of an aggregate member?");
        this.aggregateRoot.apply(event, metaData);
    }

    protected AbstractEventSourcedAggregateRoot getAggregateRoot() {
        return this.aggregateRoot;
    }
}

