/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.ArrayDeque;
import java.util.Queue;
import javax.persistence.MappedSuperclass;
import org.axonframework.common.Assert;
import org.axonframework.domain.AbstractAggregateRoot;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.DomainEventStream;
import org.axonframework.domain.GenericDomainEventMessage;
import org.axonframework.domain.MetaData;
import org.axonframework.eventsourcing.EventSourcedAggregateRoot;
import org.axonframework.eventsourcing.EventSourcedEntity;
import org.axonframework.eventsourcing.IncompatibleAggregateException;

@MappedSuperclass
public abstract class AbstractEventSourcedAggregateRoot<I>
extends AbstractAggregateRoot<I>
implements EventSourcedAggregateRoot<I> {
    private static final long serialVersionUID = 5868786029296883724L;
    private transient boolean inReplay = false;
    private transient boolean applyingEvents = false;
    private transient Queue<PayloadAndMetaData> eventsToApply = new ArrayDeque<PayloadAndMetaData>();

    @Override
    public void initializeState(DomainEventStream domainEventStream) {
        Assert.state(this.getUncommittedEventCount() == 0, "Aggregate is already initialized");
        this.inReplay = true;
        long lastSequenceNumber = -1L;
        while (domainEventStream.hasNext()) {
            DomainEventMessage event = domainEventStream.next();
            lastSequenceNumber = event.getSequenceNumber();
            this.handleRecursively(event);
        }
        this.initializeEventStream(lastSequenceNumber);
        this.inReplay = false;
    }

    protected void apply(Object eventPayload) {
        this.apply(eventPayload, MetaData.emptyInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply(Object eventPayload, MetaData metaData) {
        if (this.inReplay) {
            return;
        }
        boolean wasNested = this.applyingEvents;
        this.applyingEvents = true;
        try {
            if (this.getIdentifier() == null) {
                Assert.state(!wasNested, "Applying an event in an @EventSourcingHandler is allowed, but only *after* the aggregate identifier has been set");
                if (this.getUncommittedEventCount() > 0 || this.getVersion() != null) {
                    throw new IncompatibleAggregateException("The Aggregate Identifier has not been initialized. It must be initialized at the latest when the first event is applied.");
                }
                GenericDomainEventMessage<Object> message = new GenericDomainEventMessage<Object>(null, 0L, eventPayload, metaData);
                this.handleRecursively(message);
                this.registerEventMessage(message);
            } else {
                if (this.eventsToApply == null) {
                    this.eventsToApply = new ArrayDeque<PayloadAndMetaData>();
                }
                this.eventsToApply.add(new PayloadAndMetaData(eventPayload, metaData));
            }
            while (!wasNested && this.eventsToApply != null && !this.eventsToApply.isEmpty()) {
                PayloadAndMetaData payloadAndMetaData = this.eventsToApply.poll();
                this.handleRecursively(this.registerEvent(payloadAndMetaData.metaData, payloadAndMetaData.payload));
            }
        }
        finally {
            this.applyingEvents = wasNested;
        }
    }

    @Override
    public void commitEvents() {
        this.applyingEvents = false;
        if (this.eventsToApply != null) {
            this.eventsToApply.clear();
        }
        super.commitEvents();
    }

    protected boolean isLive() {
        return !this.inReplay;
    }

    private void handleRecursively(DomainEventMessage event) {
        this.handle(event);
        Iterable<EventSourcedEntity> childEntities = this.getChildEntities();
        if (childEntities != null) {
            for (EventSourcedEntity entity : childEntities) {
                if (entity == null) continue;
                entity.registerAggregateRoot(this);
                entity.handleRecursively(event);
            }
        }
    }

    protected abstract Iterable<? extends EventSourcedEntity> getChildEntities();

    protected abstract void handle(DomainEventMessage var1);

    @Override
    public Long getVersion() {
        return this.getLastCommittedEventSequenceNumber();
    }

    private static class PayloadAndMetaData {
        private final Object payload;
        private final MetaData metaData;

        private PayloadAndMetaData(Object payload, MetaData metaData) {
            this.payload = payload;
            this.metaData = metaData;
        }
    }
}

