/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.scheduling.quartz;

import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.scheduling.quartz.QuartzEventScheduler;
import org.axonframework.unitofwork.SpringTransactionManager;
import org.quartz.Scheduler;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;

public class QuartzEventSchedulerFactoryBean
implements FactoryBean<QuartzEventScheduler>,
InitializingBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;
    private QuartzEventScheduler eventScheduler;
    private Scheduler scheduler;
    private EventBus eventBus;
    private String groupIdentifier;
    private PlatformTransactionManager transactionManager;
    private TransactionDefinition transactionDefinition;

    public QuartzEventScheduler getObject() throws Exception {
        return this.eventScheduler;
    }

    public Class<?> getObjectType() {
        return QuartzEventScheduler.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.eventBus == null) {
            this.eventBus = (EventBus)this.applicationContext.getBean(EventBus.class);
        }
        if (this.scheduler == null) {
            this.scheduler = (Scheduler)this.applicationContext.getBean(Scheduler.class);
        }
        this.eventScheduler = new QuartzEventScheduler();
        this.eventScheduler.setScheduler(this.scheduler);
        this.eventScheduler.setEventBus(this.eventBus);
        if (this.groupIdentifier != null) {
            this.eventScheduler.setGroupIdentifier(this.groupIdentifier);
        }
        if (this.transactionManager != null) {
            this.eventScheduler.setTransactionManager(new SpringTransactionManager(this.transactionManager, this.transactionDefinition));
        }
        this.eventScheduler.initialize();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void setGroupIdentifier(String groupIdentifier) {
        this.groupIdentifier = groupIdentifier;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void setTransactionDefinition(TransactionDefinition transactionDefinition) {
        this.transactionDefinition = transactionDefinition;
    }
}

