/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.replay;

import java.util.Arrays;
import java.util.List;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.EventMessage;
import org.axonframework.eventhandling.Cluster;
import org.axonframework.eventhandling.replay.IncomingMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscardingIncomingMessageHandler
implements IncomingMessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(DiscardingIncomingMessageHandler.class);

    @Override
    public void prepareForReplay(Cluster destination) {
    }

    @Override
    public List<EventMessage> onIncomingMessages(Cluster destination, EventMessage ... messages) {
        if (messages != null && messages.length > 0 && logger.isInfoEnabled()) {
            StringBuilder msg = new StringBuilder("Discarding ").append(messages.length).append(" messages on cluster [").append(destination.getName()).append("] during an event replay: [");
            boolean firstClass = true;
            for (EventMessage message : messages) {
                if (!firstClass) {
                    msg.append(", ");
                }
                msg.append(message.getPayloadType().getSimpleName());
                firstClass = false;
            }
            msg.append("]");
            logger.info(msg.toString());
        }
        return messages == null ? null : Arrays.asList(messages);
    }

    @Override
    public List<EventMessage> releaseMessage(Cluster destination, DomainEventMessage message) {
        return null;
    }

    @Override
    public void processBacklog(Cluster destination) {
    }

    @Override
    public void onReplayFailed(Cluster destination, Throwable cause) {
    }
}

