/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.io;

import java.io.DataOutput;
import java.io.IOException;
import org.axonframework.domain.DomainEventMessage;
import org.axonframework.domain.EventMessage;
import org.axonframework.eventhandling.io.EventMessageType;
import org.axonframework.serializer.MessageSerializer;
import org.axonframework.serializer.SerializedObject;
import org.axonframework.serializer.Serializer;

public class EventMessageWriter {
    private final MessageSerializer serializer;
    private final DataOutput out;

    public EventMessageWriter(DataOutput output, Serializer serializer) {
        this.out = output;
        this.serializer = new MessageSerializer(serializer);
    }

    public void writeEventMessage(EventMessage eventMessage) throws IOException {
        if (DomainEventMessage.class.isInstance(eventMessage)) {
            this.out.writeByte(EventMessageType.DOMAIN_EVENT_MESSAGE.getTypeByte());
        } else {
            this.out.writeByte(EventMessageType.EVENT_MESSAGE.getTypeByte());
        }
        this.out.writeUTF(eventMessage.getIdentifier());
        this.out.writeUTF(eventMessage.getTimestamp().toString());
        if (eventMessage instanceof DomainEventMessage) {
            DomainEventMessage domainEventMessage = (DomainEventMessage)eventMessage;
            this.out.writeUTF(domainEventMessage.getAggregateIdentifier().toString());
            this.out.writeLong(domainEventMessage.getSequenceNumber());
        }
        SerializedObject<byte[]> serializedPayload = this.serializer.serializePayload(eventMessage, byte[].class);
        SerializedObject<byte[]> serializedMetaData = this.serializer.serializeMetaData(eventMessage, byte[].class);
        this.out.writeUTF(serializedPayload.getType().getName());
        String revision = serializedPayload.getType().getRevision();
        this.out.writeUTF(revision == null ? "" : revision);
        this.out.writeInt(serializedPayload.getData().length);
        this.out.write(serializedPayload.getData());
        this.out.writeInt(serializedMetaData.getData().length);
        this.out.write(serializedMetaData.getData());
    }
}

