/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.io;

import java.io.DataInputStream;
import java.io.IOException;
import org.axonframework.domain.EventMessage;
import org.axonframework.eventhandling.io.EventMessageType;
import org.axonframework.serializer.SerializedDomainEventMessage;
import org.axonframework.serializer.SerializedEventMessage;
import org.axonframework.serializer.SerializedMetaData;
import org.axonframework.serializer.Serializer;
import org.axonframework.serializer.SimpleSerializedObject;
import org.joda.time.DateTime;

public class EventMessageReader {
    private final Serializer serializer;
    private final DataInputStream in;

    public EventMessageReader(DataInputStream input, Serializer serializer) {
        this.in = input;
        this.serializer = serializer;
    }

    public <T> EventMessage<T> readEventMessage() throws IOException {
        int firstByte = this.in.read();
        if (firstByte == -1) {
            return null;
        }
        EventMessageType messageType = EventMessageType.fromTypeByte((byte)firstByte);
        String identifier = this.in.readUTF();
        String timestamp = this.in.readUTF();
        String aggregateIdentifier = null;
        long sequenceNumber = 0L;
        if (messageType == EventMessageType.DOMAIN_EVENT_MESSAGE) {
            aggregateIdentifier = this.in.readUTF();
            sequenceNumber = this.in.readLong();
        }
        String payloadType = this.in.readUTF();
        String payloadRevision = this.in.readUTF();
        byte[] payload = new byte[this.in.readInt()];
        this.in.readFully(payload);
        int metaDataSize = this.in.readInt();
        byte[] metaData = new byte[metaDataSize];
        this.in.readFully(metaData);
        SimpleSerializedObject<byte[]> serializedPayload = new SimpleSerializedObject<byte[]>(payload, byte[].class, payloadType, payloadRevision);
        SerializedMetaData<byte[]> serializedMetaData = new SerializedMetaData<byte[]>(metaData, byte[].class);
        SerializedEventMessage message = new SerializedEventMessage(identifier, new DateTime((Object)timestamp), serializedPayload, serializedMetaData, this.serializer);
        if (messageType == EventMessageType.DOMAIN_EVENT_MESSAGE) {
            return new SerializedDomainEventMessage(message, aggregateIdentifier, sequenceNumber);
        }
        return message;
    }
}

