/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.async;

import java.util.concurrent.TimeUnit;

public abstract class RetryPolicy {
    private static final RetryPolicy PROCEED = new SimpleRetryPolicy(0L, false, false);
    private static final RetryPolicy SKIP = new SimpleRetryPolicy(0L, true, false);

    public static RetryPolicy proceed() {
        return PROCEED;
    }

    public static RetryPolicy skip() {
        return SKIP;
    }

    public static RetryPolicy retryAfter(long timeout, TimeUnit unit) {
        return new SimpleRetryPolicy(unit.toMillis(timeout), true, true);
    }

    public abstract long waitTime();

    public abstract boolean requiresRescheduleEvent();

    public abstract boolean requiresRollback();

    private static final class SimpleRetryPolicy
    extends RetryPolicy {
        private final long waitTime;
        private final boolean rollback;
        private final boolean rescheduleEvent;

        private SimpleRetryPolicy(long waitTime, boolean rollback, boolean rescheduleEvent) {
            this.waitTime = waitTime;
            this.rollback = rollback;
            this.rescheduleEvent = rescheduleEvent;
        }

        @Override
        public long waitTime() {
            return this.waitTime;
        }

        @Override
        public boolean requiresRescheduleEvent() {
            return this.rescheduleEvent;
        }

        @Override
        public boolean requiresRollback() {
            return this.rollback;
        }
    }
}

