/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.async;

import org.axonframework.common.AxonNonTransientException;
import org.axonframework.domain.EventMessage;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventhandling.EventListenerProxy;
import org.axonframework.eventhandling.async.ErrorHandler;
import org.axonframework.eventhandling.async.RetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultErrorHandler
implements ErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultErrorHandler.class);
    private final RetryPolicy retryPolicy;

    public DefaultErrorHandler(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
    }

    @Override
    public RetryPolicy handleError(Throwable exception, EventMessage<?> eventMessage, EventListener eventListener) {
        if (this.retryPolicy.requiresRescheduleEvent() && AxonNonTransientException.isCauseOf(exception)) {
            logger.error("Override rescheduling request of retry policy, as the caught exception is non-transient. Ignoring error and proceeding", exception);
            return RetryPolicy.proceed();
        }
        if (this.retryPolicy.requiresRescheduleEvent()) {
            logger.warn("Got a [{}] while handling an event of type [{}] in [{}]. Will retry in {} millis", new Object[]{exception.toString(), eventMessage.getPayloadType().getSimpleName(), this.typeOf(eventListener), this.retryPolicy.waitTime()});
        } else {
            logger.warn("Handler [{}] threw an exception while handling event of type [{}]. {}", new Object[]{this.typeOf(eventListener), eventMessage.getPayloadType().getSimpleName(), this.retryPolicy.requiresRollback() ? "Rolling back Unit of Work and proceeding with next event" : "Continuing processing with next handler", exception});
        }
        return this.retryPolicy;
    }

    private String typeOf(EventListener eventListener) {
        if (eventListener == null) {
            return "the Unit of Work";
        }
        if (eventListener instanceof EventListenerProxy) {
            return ((EventListenerProxy)eventListener).getTargetType().getSimpleName();
        }
        return eventListener.getClass().getSimpleName();
    }
}

