/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.async;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.axonframework.common.Assert;
import org.axonframework.domain.EventMessage;
import org.axonframework.eventhandling.AbstractCluster;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventhandling.EventListenerOrderComparator;
import org.axonframework.eventhandling.MultiplexingEventProcessingMonitor;
import org.axonframework.eventhandling.OrderResolver;
import org.axonframework.eventhandling.async.DefaultErrorHandler;
import org.axonframework.eventhandling.async.ErrorHandler;
import org.axonframework.eventhandling.async.EventProcessor;
import org.axonframework.eventhandling.async.RetryPolicy;
import org.axonframework.eventhandling.async.SequencingPolicy;
import org.axonframework.unitofwork.CurrentUnitOfWork;
import org.axonframework.unitofwork.DefaultUnitOfWorkFactory;
import org.axonframework.unitofwork.TransactionManager;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkFactory;
import org.axonframework.unitofwork.UnitOfWorkListenerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsynchronousCluster
extends AbstractCluster {
    private static final Logger logger = LoggerFactory.getLogger(AsynchronousCluster.class);
    private final Executor executor;
    private final ErrorHandler errorHandler;
    private final ConcurrentMap<Object, EventProcessor> currentSchedulers = new ConcurrentHashMap<Object, EventProcessor>();
    private final SequencingPolicy<? super EventMessage<?>> sequencingPolicy;
    private final UnitOfWorkFactory unitOfWorkFactory;

    public AsynchronousCluster(String identifier, Executor executor, TransactionManager transactionManager, SequencingPolicy<? super EventMessage<?>> sequencingPolicy) {
        this(identifier, executor, transactionManager, sequencingPolicy, (ErrorHandler)new DefaultErrorHandler(RetryPolicy.retryAfter(2L, TimeUnit.SECONDS)));
    }

    public AsynchronousCluster(String identifier, Executor executor, SequencingPolicy<? super EventMessage<?>> sequencingPolicy) {
        this(identifier, executor, new DefaultUnitOfWorkFactory(), sequencingPolicy, (ErrorHandler)new DefaultErrorHandler(RetryPolicy.proceed()));
    }

    public AsynchronousCluster(String identifier, Executor executor, TransactionManager transactionManager, SequencingPolicy<? super EventMessage<?>> sequencingPolicy, ErrorHandler errorHandler) {
        this(identifier, executor, new DefaultUnitOfWorkFactory(transactionManager), sequencingPolicy, errorHandler);
    }

    public AsynchronousCluster(String name, Executor executor, UnitOfWorkFactory unitOfWorkFactory, SequencingPolicy<? super EventMessage<?>> sequencingPolicy, ErrorHandler errorHandler) {
        super(name);
        Assert.notNull(errorHandler, "errorHandler may not be null");
        Assert.notNull(unitOfWorkFactory, "unitOfWorkFactory may not be null");
        Assert.notNull(sequencingPolicy, "sequencingPolicy may not be null");
        this.errorHandler = errorHandler;
        this.executor = executor;
        this.unitOfWorkFactory = unitOfWorkFactory;
        this.sequencingPolicy = sequencingPolicy;
    }

    public AsynchronousCluster(String name, Executor executor, UnitOfWorkFactory unitOfWorkFactory, SequencingPolicy<? super EventMessage<?>> sequencingPolicy, ErrorHandler errorHandler, OrderResolver orderResolver) {
        super(name, new EventListenerOrderComparator(orderResolver));
        Assert.notNull(errorHandler, "errorHandler may not be null");
        Assert.notNull(unitOfWorkFactory, "unitOfWorkFactory may not be null");
        Assert.notNull(sequencingPolicy, "sequencingPolicy may not be null");
        this.errorHandler = errorHandler;
        this.executor = executor;
        this.unitOfWorkFactory = unitOfWorkFactory;
        this.sequencingPolicy = sequencingPolicy;
    }

    @Override
    protected void doPublish(final List<EventMessage> events, Set<EventListener> eventListeners, final MultiplexingEventProcessingMonitor eventProcessingMonitor) {
        if (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().registerListener(new UnitOfWorkListenerAdapter(){

                @Override
                public void afterCommit(UnitOfWork unitOfWork) {
                    for (EventMessage event : events) {
                        AsynchronousCluster.this.schedule(event, eventProcessingMonitor);
                    }
                }
            });
        } else {
            for (EventMessage event : events) {
                this.schedule(event, eventProcessingMonitor);
            }
        }
    }

    protected void schedule(EventMessage<?> task, MultiplexingEventProcessingMonitor eventProcessingMonitor) {
        Object sequenceIdentifier = this.sequencingPolicy.getSequenceIdentifierFor(task);
        if (sequenceIdentifier == null) {
            logger.debug("Scheduling Event for full concurrent processing {}", (Object)task.getClass().getSimpleName());
            EventProcessor scheduler = this.newProcessingScheduler(new NoActionCallback(), this.getMembers(), eventProcessingMonitor);
            scheduler.scheduleEvent(task);
        } else {
            logger.debug("Scheduling task of type [{}] for sequential processing in group [{}]", (Object)task.getClass().getSimpleName(), (Object)sequenceIdentifier.toString());
            this.assignEventToScheduler(task, sequenceIdentifier, eventProcessingMonitor);
        }
    }

    private void assignEventToScheduler(EventMessage<?> task, Object sequenceIdentifier, MultiplexingEventProcessingMonitor eventProcessingMonitor) {
        boolean taskScheduled = false;
        while (!taskScheduled) {
            EventProcessor currentScheduler = (EventProcessor)this.currentSchedulers.get(sequenceIdentifier);
            if (currentScheduler == null) {
                this.currentSchedulers.putIfAbsent(sequenceIdentifier, this.newProcessingScheduler(new SchedulerCleanUp(sequenceIdentifier), this.getMembers(), eventProcessingMonitor));
                continue;
            }
            taskScheduled = currentScheduler.scheduleEvent(task);
            if (taskScheduled) continue;
            this.currentSchedulers.remove(sequenceIdentifier, currentScheduler);
        }
    }

    protected EventProcessor newProcessingScheduler(EventProcessor.ShutdownCallback shutDownCallback, Set<EventListener> eventListeners, MultiplexingEventProcessingMonitor eventProcessingMonitor) {
        logger.debug("Initializing new processing scheduler.");
        return new EventProcessor(this.executor, shutDownCallback, this.errorHandler, this.unitOfWorkFactory, eventListeners, eventProcessingMonitor);
    }

    private final class SchedulerCleanUp
    implements EventProcessor.ShutdownCallback {
        private final Object sequenceIdentifier;

        private SchedulerCleanUp(Object sequenceIdentifier) {
            this.sequenceIdentifier = sequenceIdentifier;
        }

        @Override
        public void afterShutdown(EventProcessor scheduler) {
            logger.debug("Cleaning up processing scheduler for sequence [{}]", (Object)this.sequenceIdentifier.toString());
            AsynchronousCluster.this.currentSchedulers.remove(this.sequenceIdentifier, scheduler);
        }
    }

    private static class NoActionCallback
    implements EventProcessor.ShutdownCallback {
        private NoActionCallback() {
        }

        @Override
        public void afterShutdown(EventProcessor scheduler) {
        }
    }
}

