/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.annotation;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.axonframework.common.annotation.AbstractAnnotationHandlerBeanPostProcessor;
import org.axonframework.common.annotation.ParameterResolverFactory;
import org.axonframework.domain.AggregateRoot;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventhandling.annotation.AnnotationEventListenerAdapter;
import org.axonframework.eventhandling.annotation.EventHandler;
import org.springframework.context.SmartLifecycle;
import org.springframework.util.ReflectionUtils;

public class AnnotationEventListenerBeanPostProcessor
extends AbstractAnnotationHandlerBeanPostProcessor<EventListener, AnnotationEventListenerAdapter>
implements SmartLifecycle {
    private EventBus eventBus;

    @Override
    protected Class<EventListener> getAdapterInterface() {
        return EventListener.class;
    }

    @Override
    protected AnnotationEventListenerAdapter initializeAdapterFor(Object bean, ParameterResolverFactory parameterResolverFactory) {
        return new AnnotationEventListenerAdapter(bean, parameterResolverFactory);
    }

    @Override
    protected boolean isPostProcessingCandidate(Class<?> targetClass) {
        return this.isNotAggregateRoot(targetClass) && this.isNotEventHandlerSubclass(targetClass) && this.hasEventHandlerMethod(targetClass);
    }

    private void ensureEventBusInitialized() {
        if (this.eventBus == null) {
            Map beans = this.getApplicationContext().getBeansOfType(EventBus.class);
            if (beans.size() != 1) {
                throw new IllegalStateException("If no specific EventBus is provided, the application context must contain exactly one bean of type EventBus. The current application context has: " + beans.size());
            }
            this.eventBus = (EventBus)beans.entrySet().iterator().next().getValue();
        }
    }

    @Override
    protected void subscribe(EventListener bean, AnnotationEventListenerAdapter adapter) {
        this.ensureEventBusInitialized();
        this.eventBus.subscribe(bean);
    }

    @Override
    protected void unsubscribe(EventListener bean, AnnotationEventListenerAdapter adapter) {
        if (this.eventBus != null) {
            this.eventBus.unsubscribe(bean);
        }
    }

    private boolean isNotAggregateRoot(Class<?> targetClass) {
        return !AggregateRoot.class.isAssignableFrom(targetClass);
    }

    private boolean isNotEventHandlerSubclass(Class<?> beanClass) {
        return !EventListener.class.isAssignableFrom(beanClass);
    }

    private boolean hasEventHandlerMethod(Class<?> beanClass) {
        AtomicBoolean result = new AtomicBoolean(false);
        ReflectionUtils.doWithMethods(beanClass, (ReflectionUtils.MethodCallback)new HasEventHandlerAnnotationMethodCallback(result));
        return result.get();
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    private static final class HasEventHandlerAnnotationMethodCallback
    implements ReflectionUtils.MethodCallback {
        private final AtomicBoolean result;

        private HasEventHandlerAnnotationMethodCallback(AtomicBoolean result) {
            this.result = result;
        }

        public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
            if (method.isAnnotationPresent(EventHandler.class)) {
                this.result.set(true);
            }
        }
    }
}

