/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling.annotation;

import java.lang.annotation.Annotation;
import org.axonframework.common.Assert;
import org.axonframework.common.CollectionUtils;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.common.annotation.ParameterResolver;
import org.axonframework.common.annotation.ParameterResolverFactory;

public abstract class AbstractAnnotatedParameterResolverFactory<A, P>
implements ParameterResolverFactory {
    private final Class<A> annotationType;
    private final Class<P> declaredParameterType;

    protected AbstractAnnotatedParameterResolverFactory(Class<A> annotationType, Class<P> declaredParameterType) {
        Assert.notNull(annotationType, "annotationType may not be null");
        Assert.notNull(declaredParameterType, "declaredParameterType may not be null");
        this.annotationType = annotationType;
        this.declaredParameterType = declaredParameterType;
    }

    protected abstract ParameterResolver<P> getResolver();

    @Override
    public ParameterResolver createInstance(Annotation[] memberAnnotations, Class<?> parameterType, Annotation[] parameterAnnotations) {
        A annotation = CollectionUtils.getAnnotation(parameterAnnotations, this.annotationType);
        if (annotation != null) {
            if (parameterType.isAssignableFrom(this.declaredParameterType)) {
                return this.getResolver();
            }
            if (parameterType.isPrimitive() && ReflectionUtils.resolvePrimitiveWrapperType(parameterType).isAssignableFrom(this.declaredParameterType)) {
                return this.getResolver();
            }
        }
        return null;
    }
}

