/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.axonframework.eventhandling.SimpleEventBusStatisticsMXBean;

public class SimpleEventBusStatistics
implements SimpleEventBusStatisticsMXBean {
    private final AtomicLong listenerCount = new AtomicLong(0L);
    private final AtomicLong publishedEventCounter = new AtomicLong(0L);
    private final List<String> listeners = new CopyOnWriteArrayList<String>();

    SimpleEventBusStatistics() {
    }

    @Override
    public long getListenerCount() {
        return this.listenerCount.get();
    }

    @Override
    public long getReceivedEventsCount() {
        return this.publishedEventCounter.get();
    }

    @Override
    public void resetReceivedEventsCount() {
        this.publishedEventCounter.set(0L);
    }

    @Override
    public List<String> getListenerTypes() {
        return Collections.unmodifiableList(this.listeners);
    }

    void listenerRegistered(String name) {
        this.listeners.add(name);
        this.listenerCount.incrementAndGet();
    }

    void recordUnregisteredListener(String name) {
        this.listeners.remove(name);
        this.listenerCount.decrementAndGet();
    }

    void recordPublishedEvent() {
        this.publishedEventCounter.incrementAndGet();
    }
}

