/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.axonframework.domain.EventMessage;
import org.axonframework.eventhandling.EventBus;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventhandling.EventListenerProxy;
import org.axonframework.eventhandling.SimpleEventBusStatistics;
import org.axonframework.monitoring.MonitorRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEventBus
implements EventBus {
    private static final Logger logger = LoggerFactory.getLogger(SimpleEventBus.class);
    private final Set<EventListener> listeners = new CopyOnWriteArraySet<EventListener>();
    private final SimpleEventBusStatistics statistics = new SimpleEventBusStatistics();

    public SimpleEventBus() {
        MonitorRegistry.registerMonitoringBean(this.statistics, SimpleEventBus.class);
    }

    @Override
    public void unsubscribe(EventListener eventListener) {
        String listenerType = this.classNameOf(eventListener);
        if (this.listeners.remove(eventListener)) {
            this.statistics.recordUnregisteredListener(listenerType);
            logger.debug("EventListener {} unsubscribed successfully", (Object)listenerType);
        } else {
            logger.info("EventListener {} not removed. It was already unsubscribed", (Object)listenerType);
        }
    }

    @Override
    public void subscribe(EventListener eventListener) {
        String listenerType = this.classNameOf(eventListener);
        if (this.listeners.add(eventListener)) {
            this.statistics.listenerRegistered(listenerType);
            logger.debug("EventListener [{}] subscribed successfully", (Object)listenerType);
        } else {
            logger.info("EventListener [{}] not added. It was already subscribed", (Object)listenerType);
        }
    }

    @Override
    public void publish(EventMessage ... events) {
        this.statistics.recordPublishedEvent();
        if (!this.listeners.isEmpty()) {
            for (EventMessage event : events) {
                for (EventListener listener : this.listeners) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Dispatching Event [{}] to EventListener [{}]", (Object)event.getPayloadType().getSimpleName(), (Object)this.classNameOf(listener));
                    }
                    listener.handle(event);
                }
            }
        }
    }

    private String classNameOf(EventListener eventListener) {
        Class<?> listenerType = eventListener instanceof EventListenerProxy ? ((EventListenerProxy)eventListener).getTargetType() : eventListener.getClass();
        return listenerType.getSimpleName();
    }
}

