/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventhandling;

import java.util.List;
import java.util.Set;
import org.axonframework.domain.EventMessage;
import org.axonframework.eventhandling.AbstractCluster;
import org.axonframework.eventhandling.EventListener;
import org.axonframework.eventhandling.EventListenerOrderComparator;
import org.axonframework.eventhandling.EventProcessingMonitor;
import org.axonframework.eventhandling.MultiplexingEventProcessingMonitor;
import org.axonframework.eventhandling.OrderResolver;
import org.axonframework.unitofwork.CurrentUnitOfWork;
import org.axonframework.unitofwork.UnitOfWork;
import org.axonframework.unitofwork.UnitOfWorkListenerAdapter;

public class SimpleCluster
extends AbstractCluster {
    public SimpleCluster(String name) {
        super(name);
    }

    public SimpleCluster(String name, OrderResolver orderResolver) {
        super(name, new EventListenerOrderComparator(orderResolver));
    }

    @Override
    public void doPublish(List<EventMessage> events, Set<EventListener> eventListeners, MultiplexingEventProcessingMonitor monitor) {
        try {
            for (EventMessage event : events) {
                for (EventListener eventListener : eventListeners) {
                    eventListener.handle(event);
                }
            }
            this.notifyMonitors(events, monitor, null);
        }
        catch (RuntimeException e) {
            this.notifyMonitors(events, monitor, e);
            throw e;
        }
    }

    private void notifyMonitors(List<EventMessage> events, EventProcessingMonitor monitor, RuntimeException exception) {
        if (CurrentUnitOfWork.isStarted()) {
            CurrentUnitOfWork.get().registerListener(new MonitorInvoker(monitor, events, exception));
        } else if (exception == null) {
            monitor.onEventProcessingCompleted(events);
        } else {
            monitor.onEventProcessingFailed(events, exception);
        }
    }

    private static class MonitorInvoker
    extends UnitOfWorkListenerAdapter {
        private final EventProcessingMonitor monitor;
        private final List<EventMessage> events;
        private final RuntimeException exception;

        public MonitorInvoker(EventProcessingMonitor monitor, List<EventMessage> events, RuntimeException exception) {
            this.monitor = monitor;
            this.events = events;
            this.exception = exception;
        }

        @Override
        public void afterCommit(UnitOfWork unitOfWork) {
            this.monitor.onEventProcessingCompleted(this.events);
        }

        @Override
        public void onRollback(UnitOfWork unitOfWork, Throwable failureCause) {
            this.monitor.onEventProcessingFailed(this.events, this.exception == null ? failureCause : this.exception);
        }
    }
}

